/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.rm.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.mule.soap.internal.rm.store.MessageTransfer;

public class SourceSequenceTransfer
implements Serializable {
    private long currentMessageNumber;
    private boolean lastMessage;
    private long expiry;
    private String offeringIdValue;
    private String endpointIdentifier;
    private String encodedProtocolVersion;
    private List<MessageTransfer> messageTransfers;

    public SourceSequenceTransfer(SourceSequence sourceSequence) {
        this.currentMessageNumber = sourceSequence.getCurrentMessageNr();
        this.lastMessage = sourceSequence.isLastMessage();
        Date expiryDate = sourceSequence.getExpires();
        this.expiry = expiryDate == null ? 0L : expiryDate.getTime();
        Identifier offeringId = sourceSequence.getOfferingSequenceIdentifier();
        this.offeringIdValue = offeringId == null ? null : offeringId.getValue();
        this.endpointIdentifier = sourceSequence.getSource() == null ? null : sourceSequence.getEndpointIdentifier();
        this.encodedProtocolVersion = this.encodeProtocolVersion(sourceSequence.getProtocol());
        this.messageTransfers = new ArrayList<MessageTransfer>();
    }

    public long getCurrentMessageNumber() {
        return this.currentMessageNumber;
    }

    public void setCurrentMessageNumber(long currentMessageNumber) {
        this.currentMessageNumber = currentMessageNumber;
    }

    public boolean isLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(boolean lastMessage) {
        this.lastMessage = lastMessage;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public String getOfferingIdValue() {
        return this.offeringIdValue;
    }

    public void setOfferingIdValue(String offeringIdValue) {
        this.offeringIdValue = offeringIdValue;
    }

    public String getEndpointIdentifier() {
        return this.endpointIdentifier;
    }

    public void setEndpointIdentifier(String endpointIdentifier) {
        this.endpointIdentifier = endpointIdentifier;
    }

    public String getEncodedProtocolVersion() {
        return this.encodedProtocolVersion;
    }

    public void setEncodedProtocolVersion(String encodedProtocolVersion) {
        this.encodedProtocolVersion = encodedProtocolVersion;
    }

    public List<MessageTransfer> getMessageTransfers() {
        return this.messageTransfers;
    }

    public void setMessageTransfers(ArrayList<MessageTransfer> messageTransfers) {
        this.messageTransfers = messageTransfers;
    }

    public void addMessageTransfer(MessageTransfer messageTransfer) {
        this.messageTransfers.add(messageTransfer);
    }

    private String encodeProtocolVersion(ProtocolVariation protocolVariation) {
        return protocolVariation.getCodec().getWSRMNamespace() + ' ' + protocolVariation.getCodec().getWSANamespace();
    }
}

