package org.mule.soap.api.transport;

import org.apache.commons.collections4.map.CaseInsensitiveMap;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

/**
 * Base message implementation for sending, receiving contents through a custom transport.
 *
 * @since 1.0
 */
abstract class TransportMessage {

  private static final String CONTENT_TYPE = "Content-Type";

  private final InputStream content;
  private final Map<String, String> headers;

  TransportMessage(InputStream content, Map<String, String> headers) {
    this.content = content;
    this.headers = new CaseInsensitiveMap<>(headers);
  }

  public InputStream getContent() {
    return this.content;
  }

  public String getContentType() {
    return getHeader(CONTENT_TYPE)
        .orElseThrow(() -> new IllegalStateException("No Content-Type boundled in the message"));
  }

  public Map<String, String> getHeaders() {
    return this.headers;
  }

  public Optional<String> getHeader(String headerName) {
    return Optional.ofNullable(this.headers.get(headerName));
  }

}
