/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.interceptor.gzip;

import com.google.common.net.HttpHeaders;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.mule.soap.internal.client.AbstractSoapCxfClient;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractProxyGZIPInterceptor extends AbstractPhaseInterceptor<Message> {

  public AbstractProxyGZIPInterceptor(String phase) {
    super(phase);
  }

  protected boolean isEncoded(Message message) {
    boolean isEncoded = false;
    Map<String, String> headers =
        (Map<String, String>) message.getExchange().get(AbstractSoapCxfClient.MULE_TRANSPORT_HEADERS_KEY);

    Optional<String> header = Optional.ofNullable(headers.get(HttpHeaders.CONTENT_ENCODING));

    if (!header.isPresent()) {
      header = Optional.ofNullable(headers.get(HttpHeaders.CONTENT_ENCODING.toLowerCase()));
    }

    if (!header.isPresent()) {
      header = Optional.ofNullable(headers.get(GZIPOutInterceptor.SOAP_JMS_CONTENTENCODING));
    }

    if (header.isPresent()) {
      List<String> encodings = Arrays.asList(GZIPOutInterceptor.ENCODINGS.split(header.get().trim()));
      isEncoded = encodings.contains("gzip") || encodings.contains("x-gzip");
    }

    return isEncoded;
  }
}
