/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.client;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMStoreException;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.client.BadResponseException;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.exception.ReliableMessagingStoreException;
import org.mule.soap.api.exception.SoapFaultException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.rm.TerminateSequenceRequest;
import org.mule.soap.api.transport.DispatcherException;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.generator.SoapRequestGenerator;
import org.mule.soap.internal.generator.SoapResponseGenerator;
import org.mule.soap.internal.generator.attachment.AttachmentRequestEnricher;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.soap.internal.rm.RMClient;
import org.mule.soap.internal.rm.RMUtils;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.mule.wsdl.parser.exception.OperationNotFoundException;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.mule.wsdl.parser.model.operation.OperationType;

public abstract class AbstractSoapCxfClient
implements SoapClient {
    public static final String MESSAGE_DISPATCHER = "mule.soap.dispatcher";
    public static final String MULE_ATTACHMENTS_KEY = "mule.soap.attachments";
    public static final String MULE_WSC_ADDRESS = "mule.soap.address";
    public static final String MULE_HEADERS_KEY = "mule.soap.headers";
    public static final String MULE_TRANSPORT_HEADERS_KEY = "mule.soap.transport.headers";
    public static final String MULE_TRANSPORT_ADDITIONAL_DATA_KEY = "mule.soap.transport.additionalData";
    public static final String MULE_SOAP_ACTION = "mule.soap.action";
    public static final String MULE_SOAP_OPERATION_STYLE = "mule.soap.operation.type";
    public static final String MULE_ENABLE_NAMESPACES = "mule.soap.enable.namespaces";
    private final SoapRequestGenerator requestGenerator;
    private final SoapResponseGenerator responseGenerator;
    private final Client client;
    private final WsdlModel wsdlModel;
    private final PortModel port;
    private final String address;
    private final String encoding;
    private final RMClient reliableMessaging;

    AbstractSoapCxfClient(Client client, WsdlModel wsdlModel, PortModel portModel, String address, String encoding, AttachmentRequestEnricher requestEnricher, AttachmentResponseEnricher responseEnricher) {
        this.client = client;
        this.wsdlModel = wsdlModel;
        this.port = portModel;
        this.address = address;
        this.encoding = encoding;
        this.requestGenerator = new SoapRequestGenerator(requestEnricher, portModel);
        this.responseGenerator = new SoapResponseGenerator(responseEnricher);
        this.reliableMessaging = new RMClient(client, address);
    }

    @Override
    public SoapResponse consume(SoapRequest request, TransportDispatcher dispatcher) {
        Objects.requireNonNull(dispatcher, "Message Dispatcher cannot be null");
        String operation = request.getOperation();
        ExchangeImpl exchange = new ExchangeImpl();
        Object[] response = this.invoke(request, (Exchange)exchange, dispatcher);
        return this.responseGenerator.generate(operation, response, (Exchange)exchange);
    }

    @Override
    public SoapResponse parseResponse(String operation, TransportResponse transportResponse) {
        Objects.requireNonNull(transportResponse, "Transport response cannot be null");
        ExchangeImpl exchange = new ExchangeImpl();
        Object[] response = this.invoke(operation, transportResponse, (Exchange)exchange);
        return this.responseGenerator.generate(operation, response, (Exchange)exchange);
    }

    @Override
    public String createSequence(CreateSequenceRequest request, TransportDispatcher dispatcher) {
        Objects.requireNonNull(dispatcher, "Message Dispatcher cannot be null");
        try {
            SourceSequence sequence = this.reliableMessaging.createSequence(request, dispatcher);
            return sequence.getIdentifier().getValue();
        }
        catch (SoapFault sf) {
            throw new SoapFaultException(sf);
        }
        catch (Fault f) {
            throw new SoapFaultException(f);
        }
        catch (DispatcherException d) {
            throw d;
        }
        catch (RMStoreException e) {
            throw new ReliableMessagingStoreException("Unable to create RM sequence", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while creating a sequence", e);
        }
    }

    @Override
    public void terminateSequence(TerminateSequenceRequest request, TransportDispatcher dispatcher) {
        Objects.requireNonNull(dispatcher, "Message Dispatcher cannot be null");
        try {
            this.reliableMessaging.terminateSequence(request, dispatcher);
        }
        catch (SoapFault sf) {
            throw new SoapFaultException(sf);
        }
        catch (Fault f) {
            throw new SoapFaultException(f);
        }
        catch (BadRequestException | DispatcherException d) {
            throw d;
        }
        catch (RMStoreException e) {
            throw new ReliableMessagingStoreException("Unable to update or remove RM sequence", e);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unexpected error while terminating sequence [%s].", request.getSequenceIdentifier()), e);
        }
    }

    @Override
    public void destroy() {
        this.client.destroy();
    }

    private Object[] invoke(SoapRequest request, Exchange exchange, TransportDispatcher dispatcher) {
        String ope = request.getOperation();
        XMLStreamReader xmlBody = this.getXmlBody(request);
        try {
            Map<String, Object> ctx = this.getInvocationContext(request, dispatcher);
            return this.client.invoke(this.getInvocationOperation(ope), new Object[]{xmlBody}, ctx, exchange);
        }
        catch (SoapFault sf) {
            throw new SoapFaultException(sf, this.getAdditionalTransportData(exchange));
        }
        catch (Fault f) {
            if (f.getMessage().contains("COULD_NOT_READ_XML")) {
                throw new BadRequestException("Error consuming the operation [" + ope + "], the request body is not a valid XML", this.getAdditionalTransportData(exchange));
            }
            throw new SoapFaultException(f);
        }
        catch (OperationNotFoundException e) {
            String errorMsg = "The provided operation [" + ope + "] does not exist in the WSDL file [" + this.wsdlModel.getLocation() + "]";
            throw new BadRequestException(errorMsg, e, this.getAdditionalTransportData(exchange));
        }
        catch (BadRequestException | DispatcherException e) {
            throw e;
        }
        catch (RMStoreException e) {
            throw new ReliableMessagingStoreException("Unable to update RM sequence", e, this.getAdditionalTransportData(exchange));
        }
        catch (ClientImpl.IllegalEmptyResponseException e) {
            throw new BadResponseException(e.getMessage(), e, this.getAdditionalTransportData(exchange));
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while consuming the web service operation [" + ope + "]", e);
        }
    }

    private Map<String, String> getAdditionalTransportData(Exchange exchange) {
        Object additionalDataValue = exchange.get((Object)MULE_TRANSPORT_ADDITIONAL_DATA_KEY);
        if (additionalDataValue instanceof Map) {
            return (Map)additionalDataValue;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] invoke(String operation, TransportResponse response, Exchange exchange) {
        try (ReplyHandler handler = new ReplyHandler(this.client.getBus(), this.client.getEndpoint(), this.client.getConduit());){
            Object[] objectArray = handler.invoke(exchange, response);
            return objectArray;
        }
        catch (SoapFault sf) {
            if (!sf.getMessage().contains("Error reading XMLStreamReader")) throw new SoapFaultException(sf);
            this.badResponseException(operation, (Fault)((Object)sf));
            throw new SoapFaultException(sf);
        }
        catch (Fault f) {
            if (f.getCause() == null) throw new SoapFaultException(f);
            if (!(f.getCause() instanceof IOException)) throw new SoapFaultException(f);
            return this.badResponseException(operation, f);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while handling the reply of the web service operation [" + operation + "]", e);
        }
    }

    private Object[] badResponseException(String operation, Fault f) {
        throw new BadResponseException("Error processing the response of the operation [" + operation + "], check if the content-type is correct.", f);
    }

    private XMLStreamReader getXmlBody(SoapRequest request) {
        return this.requestGenerator.generate(request.getOperation(), request.getContent(), this.getEncoding(request), request.getAttachments());
    }

    private BindingOperationInfo getInvocationOperation(String operationName) {
        Endpoint ep = this.client.getEndpoint();
        String method = this.port.getOperation(operationName).getType().equals((Object)OperationType.ONE_WAY) ? "invokeOneWay" : "invoke";
        QName q = new QName(ep.getService().getName().getNamespaceURI(), method);
        BindingOperationInfo bop = ep.getBinding().getBindingInfo().getOperation(q);
        if (bop.isUnwrappedCapable()) {
            bop = bop.getUnwrappedOperation();
        }
        return bop;
    }

    private Map<String, Object> getInvocationContext(SoapRequest request, TransportDispatcher dispatcher) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        OperationModel operation = this.port.getOperation(request.getOperation());
        props.put(MULE_ATTACHMENTS_KEY, this.buildCxfAttachments(request.getAttachments()));
        props.put(MULE_WSC_ADDRESS, this.address);
        props.put(Message.ENCODING, this.getEncoding(request));
        props.put(MULE_HEADERS_KEY, this.buildCxfHeaders(request.getSoapHeaders()));
        props.put(MULE_TRANSPORT_HEADERS_KEY, request.getTransportHeaders());
        props.put(MESSAGE_DISPATCHER, dispatcher);
        props.put(MULE_SOAP_OPERATION_STYLE, operation.getType());
        String soapAction = operation.getSoapAction();
        if (soapAction != null) {
            props.put(MULE_SOAP_ACTION, soapAction);
        }
        props.put("org.apache.cxf.stax.force-start-document", request.isUseXMLInitialDeclaration());
        request.getAddressingProperties().ifPresent(addressingProperties -> RMUtils.enableAddressing(props, addressingProperties));
        request.getReliableMessagingProperties().ifPresent(rmProperties -> {
            SourceSequence sourceSequence = this.reliableMessaging.getSourceSequence(rmProperties.getSequenceIdentifier());
            if (sourceSequence == null) {
                throw new BadRequestException(String.format("Error consuming the operation [%s], the WSRM sequence identifier is not valid [%s].", request.getOperation(), rmProperties.getSequenceIdentifier()));
            }
            RMUtils.enableReliableMessaging(props, rmProperties, sourceSequence);
        });
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("RequestContext", props);
        return ctx;
    }

    private String getEncoding(SoapRequest request) {
        try {
            return new ContentType(request.getContentType()).getParameter("charset");
        }
        catch (ParseException e) {
            return StringUtils.isBlank((CharSequence)this.encoding) ? "UTF-8" : this.encoding;
        }
    }

    protected abstract Map<String, Attachment> buildCxfAttachments(Map<String, SoapAttachment> var1);

    private List<SoapHeader> buildCxfHeaders(Map<String, String> headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.entrySet().stream().map(header -> {
            try {
                return new SoapHeader(new QName(null, (String)header.getKey()), (Object)XmlTransformationUtils.stringToDomElement((String)header.getValue()));
            }
            catch (Exception e) {
                throw new BadRequestException("Cannot parse input header [" + (String)header.getKey() + "]", e);
            }
        }).collect(Collectors.toList());
    }

    private class ReplyHandler
    extends ClientImpl {
        private final Charset DEFAULT_ENCODING;

        public ReplyHandler(Bus b, Endpoint e, Conduit c) {
            super(b, e, c);
            this.DEFAULT_ENCODING = StandardCharsets.UTF_8;
        }

        public Object[] invoke(Exchange exchange, TransportResponse response) throws Exception {
            this.initExchange(exchange, response.getHeaders(), response.getAdditionalData());
            Message message = this.newMessage(response.getContentType(), response.getContent());
            message.setExchange(exchange);
            this.getConduit().getMessageObserver().onMessage(message);
            Exception ex = this.getException(exchange);
            if (ex != null) {
                throw ex;
            }
            List list = (List)exchange.getInMessage().getContent(List.class);
            return list != null ? list.toArray() : null;
        }

        private Exchange initExchange(Exchange exchange, Map<String, String> headers, Map<String, String> additionalData) {
            exchange.put(Bus.class, (Object)this.getBus());
            exchange.put(Service.class, (Object)this.getEndpoint().getService());
            exchange.put((Object)AbstractSoapCxfClient.MULE_TRANSPORT_HEADERS_KEY, headers);
            exchange.put((Object)AbstractSoapCxfClient.MULE_TRANSPORT_ADDITIONAL_DATA_KEY, additionalData);
            exchange.put((Object)AbstractSoapCxfClient.MULE_ATTACHMENTS_KEY, Collections.emptyMap());
            exchange.setOutMessage((Message)new MessageImpl());
            exchange.put((Object)StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
            return exchange;
        }

        private Message newMessage(String contentType, InputStream content) {
            Object responseEncoding = this.resolveEncoding(contentType).orElse(this.DEFAULT_ENCODING.name());
            MessageImpl message = new MessageImpl();
            message.put((Object)"Content-Type", (Object)contentType);
            message.put((Object)Message.ENCODING, responseEncoding);
            message.setContent(InputStream.class, (Object)content);
            return message;
        }

        private Optional<Object> resolveEncoding(String contentType) {
            try {
                MediaType mediaType = MediaType.parse((String)contentType);
                return mediaType.charset().isPresent() ? Optional.of(((Charset)mediaType.charset().get()).name()) : Optional.empty();
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }

        public void close() throws Exception {
        }
    }
}

