package org.mule.soap.api.rm;

/**
 * Represents a request that aims to terminate a RM sequence
 *
 * @since 1.6
 */
public interface TerminateSequenceRequest {

  /**
   * @return the target sequence identifier.
   */
  String getSequenceIdentifier();

  /**
   * @return a {@link TerminateSequenceRequestBuilder} instance to create a new {@link TerminateSequenceRequest}.
   */
  static TerminateSequenceRequestBuilder builder() {
    return new TerminateSequenceRequestBuilder();
  }
}
