/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.interceptor.gzip;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;

public class ProxyGZIPFeature extends AbstractFeature {

  @Override
  protected void initializeProvider(InterceptorProvider provider, Bus bus) {
    ProxyGZIPOutInterceptor out = new ProxyGZIPOutInterceptor();

    provider.getInInterceptors().add(new ProxyGZIPInInterceptor());
    provider.getOutInterceptors().add(out);
    provider.getOutFaultInterceptors().add(out);
  }

}
