package org.mule.soap.internal.rm;

import static java.lang.Boolean.TRUE;
import static org.apache.cxf.helpers.IOUtils.copyAndCloseInput;
import static org.apache.cxf.ws.addressing.JAXWSAConstants.CLIENT_ADDRESSING_PROPERTIES;
import static org.apache.cxf.ws.addressing.MAPAggregator.ADDRESSING_NAMESPACE;
import static org.apache.cxf.ws.rm.RMManager.WSRM_VERSION_PROPERTY;
import static org.apache.cxf.ws.rm.RMManager.WSRM_WSA_VERSION_PROPERTY;

import org.mule.soap.api.message.AddressingProperties;
import org.mule.soap.api.message.ReliableMessagingProperties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.PersistenceUtils;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

public class RMUtils {

  public static final String MULE_RM_ENABLE = "mule.reliablemessaging.enable";
  public static final String MULE_RM_SEQUENCE = "mule.reliablemessaging.sequence";
  public static final String MULE_ADDRESSING_ENABLE = "mule.addressing.enable";

  public static String getReliableMessagingSequence(Message message) {
    return (String) message.get(MULE_RM_SEQUENCE);
  }

  public static boolean isReliableMessagingEnable(Message message) {
    return PropertyUtils.isTrue(message.get(MULE_RM_ENABLE));
  }

  public static boolean isAddressingEnable(Message message) {
    return PropertyUtils.isTrue(message.get(MULE_ADDRESSING_ENABLE));
  }

  public static void enableAddressing(Map<String, Object> props, AddressingProperties addressingProperties) {
    props.put(CLIENT_ADDRESSING_PROPERTIES, buildCxfAddressingProperties(addressingProperties));
    props.put(MULE_ADDRESSING_ENABLE, TRUE);
  }

  public static void enableReliableMessaging(Map<String, Object> props, ReliableMessagingProperties rmProperties,
                                             SourceSequence sourceSequence) {
    props.put(MULE_RM_SEQUENCE, rmProperties.getSequenceIdentifier());
    props.put(ADDRESSING_NAMESPACE, sourceSequence.getProtocol().getWSANamespace());
    props.put(WSRM_VERSION_PROPERTY, sourceSequence.getProtocol().getWSRMNamespace());
    props.put(WSRM_WSA_VERSION_PROPERTY, sourceSequence.getProtocol().getWSANamespace());
    props.put(MULE_ADDRESSING_ENABLE, TRUE);
    props.put(MULE_RM_ENABLE, TRUE);
  }

  public static void copySettings(Message request, Message response) {
    response.put(MULE_RM_ENABLE, request.get(MULE_RM_ENABLE));
    response.put(MULE_RM_SEQUENCE, request.get(MULE_RM_SEQUENCE));
    response.put(MULE_ADDRESSING_ENABLE, request.get(MULE_ADDRESSING_ENABLE));
  }

  public static byte[] toByteArray(SequenceAcknowledgement obj) throws IOException {
    InputStream stream = PersistenceUtils.getInstance().serialiseAcknowledgment(obj);
    return IOUtils.toByteArray(stream);
  }

  public static SequenceAcknowledgement toSequenceAcknowledgement(byte[] obj) {
    InputStream stream = new ByteArrayInputStream(obj);
    return PersistenceUtils.getInstance().deserialiseAcknowledgment(stream);
  }

  public static void copyAndClose(byte[] input, OutputStream output) throws IOException {
    InputStream stream = new ByteArrayInputStream(input);
    copyAndCloseInput(stream, output);
  }

  private static org.apache.cxf.ws.addressing.AddressingProperties buildCxfAddressingProperties(AddressingProperties addressingProperties) {
    org.apache.cxf.ws.addressing.AddressingProperties props =
        new org.apache.cxf.ws.addressing.AddressingProperties(addressingProperties.getNamespace());
    props.setTo(getAttributedURIType(addressingProperties.getTo()));
    props.setAction(getAttributedURIType(addressingProperties.getAction()));
    addressingProperties.getFrom().ifPresent(from -> props.setFrom(getEndpointReference(from)));
    addressingProperties.getMessageId().ifPresent(messageId -> props.setMessageID(getAttributedURIType(messageId)));
    addressingProperties.getRelatesTo().ifPresent(relatesTo -> props.setRelatesTo(getRelatesToType(relatesTo)));
    return props;
  }

  private static RelatesToType getRelatesToType(String value) {
    RelatesToType relatesTo = new RelatesToType();
    relatesTo.setValue(value);
    return relatesTo;
  }

  private static AttributedURIType getAttributedURIType(String value) {
    AttributedURIType type = new AttributedURIType();
    type.setValue(value);
    return type;
  }

  private static EndpointReferenceType getEndpointReference(String address) {
    EndpointReferenceType reference = new EndpointReferenceType();
    reference.setAddress(getAttributedURIType(address));
    return reference;
  }

  private RMUtils() {}
}
