/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.attachment.AttachmentRequestEnricher;

public abstract class AbstractRequestEnricherTestCase
extends AbstractEnricherTestCase {
    @Test
    public void enrich() throws Exception {
        SoapAttachment attachment = this.getTestAttachment();
        AttachmentRequestEnricher enricher = this.getEnricher();
        XMLStreamReader request = enricher.enrichRequest("uploadAttachment", (InputStream)new ByteArrayInputStream(this.testValues.getUploadAttachmentRequest().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8.name(), Collections.singletonMap("attachment-id", attachment));
        SoapTestUtils.assertSimilarXml(this.getExpectedResult(), this.getXmlStreamAsString(request));
    }

    private SoapAttachment getTestAttachment() {
        SoapAttachment attachment = (SoapAttachment)Mockito.mock(SoapAttachment.class);
        Mockito.when((Object)attachment.getContent()).thenReturn((Object)IOUtils.toInputStream((String)"Some Content"));
        Mockito.when((Object)attachment.getContentType()).thenReturn((Object)"text/plain");
        return attachment;
    }

    protected abstract AttachmentRequestEnricher getEnricher();

    protected abstract String getExpectedResult();
}

