/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.unit;

import java.io.IOException;
import java.util.Collections;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.internal.interceptor.TransportRequestFactory;
import org.mule.soap.internal.util.DelegatingOutputStream;

public class TransportRequestFactoryTestCase {
    private static final String CONTENT = "<a>content</a>";
    private static final byte[] BINARY_CONTENT = new byte[]{-59, -106, 6, 80, -59, -95, -63, 46, 4, 21, -101, -102, 0, 21, 3, 0};
    private static final String SOAP_ACTION_VALUE = "noOPE";

    @Test
    public void checkOverrideDefaultHeaders() throws IOException {
        Message messageMock = this.getMessageMock(CONTENT.getBytes());
        TransportRequest dispatchingRequest = TransportRequestFactory.createDispatchingRequest((Message)messageMock);
        Assert.assertThat(dispatchingRequest.getHeader("SOAPAction").get(), (Matcher)Is.is((Object)SOAP_ACTION_VALUE));
    }

    @Test
    public void contentTypeIsAddedToTransportHeaders() throws IOException {
        Message messageMock = this.getMessageMock(CONTENT.getBytes());
        TransportRequest dispatchingRequest = TransportRequestFactory.createDispatchingRequest((Message)messageMock);
        Assert.assertThat(dispatchingRequest.getHeader("Content-Type").get(), (Matcher)Is.is((Object)"application/soap+xml; charset=ISO-2022-KR"));
    }

    @Test
    public void byteDataIsDeliveredAsBinary() throws IOException {
        Message messageMock = this.getMessageMock(BINARY_CONTENT);
        TransportRequest dispatchingRequest = TransportRequestFactory.createDispatchingRequest((Message)messageMock);
        byte[] dispatchingContent = new byte[16];
        dispatchingRequest.getContent().read(dispatchingContent);
        Assert.assertThat((Object)dispatchingContent, (Matcher)Is.is((Object)BINARY_CONTENT));
    }

    private Message getMessageMock(byte[] content) throws IOException {
        Exchange exchangeMock = (Exchange)Mockito.mock(Exchange.class);
        DelegatingOutputStream os = new DelegatingOutputStream();
        os.write(content);
        Mockito.when((Object)exchangeMock.get((Object)"mule.soap.transport.headers")).thenReturn(Collections.singletonMap("SOAPAction".toLowerCase(), SOAP_ACTION_VALUE));
        Message messageMock = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)messageMock.getContent(DelegatingOutputStream.class)).thenReturn((Object)os);
        Mockito.when((Object)messageMock.get((Object)"Content-Type")).thenReturn((Object)"application/soap+xml; charset=ISO-2022-KR");
        Mockito.when((Object)messageMock.getExchange()).thenReturn((Object)exchangeMock);
        return messageMock;
    }
}

