/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.message.Message;
import org.mule.soap.internal.interceptor.gzip.AbstractProxyGZIPInterceptor;
import org.mule.soap.internal.util.DelegatingOutputStream;

public class ProxyGZIPOutInterceptor
extends AbstractProxyGZIPInterceptor {
    public ProxyGZIPOutInterceptor() {
        super("prepare-send");
        this.addAfter(MessageSenderInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isEncoded(message)) {
            DelegatingOutputStream os = (DelegatingOutputStream)message.getContent(DelegatingOutputStream.class);
            if (os == null) {
                return;
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(os.getOutputStream().size());
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
                gzipOutputStream.write(os.getOutputStream().toByteArray());
                gzipOutputStream.close();
                ((DelegatingOutputStream)message.getContent(DelegatingOutputStream.class)).setOutputStream(baos);
            }
            catch (IOException io) {
                throw new Fault((Throwable)io);
            }
        }
    }
}

