package org.mule.soap.api.rm;

import org.mule.soap.internal.rm.DefaultCreateSequenceRequest;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A builder implementation to create {@link CreateSequenceRequest}s
 *
 * @since 1.6
 */
public class CreateSequenceRequestBuilder {

  private long sequenceTtl;
  private String namespaceUri;
  private String addressingNamespaceUri;

  public CreateSequenceRequestBuilder sequenceTtl(long sequenceTtl) {
    this.sequenceTtl = sequenceTtl;
    return this;
  }

  public CreateSequenceRequestBuilder namespaceUri(String namespaceUri) {
    this.namespaceUri = namespaceUri;
    return this;
  }

  public CreateSequenceRequestBuilder addressingNamespaceUri(String addressingNamespaceUri) {
    this.addressingNamespaceUri = addressingNamespaceUri;
    return this;
  }

  public CreateSequenceRequest build() {
    checkNotNull(namespaceUri, "Namespace URI cannot be null.");
    return new DefaultCreateSequenceRequest(sequenceTtl, namespaceUri, addressingNamespaceUri);
  }
}
