/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.apache.xerces.impl.dv.util.Base64;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.soap.internal.generator.attachment.MtomResponseEnricher;

public class MtomResponseEnricherTestCase
extends AbstractEnricherTestCase {
    private AttachmentResponseEnricher enricher;

    @Override
    @Before
    public void setup() {
        super.setup();
        List ops = this.model.getService("TestService").getPort("TestPort").getOperations();
        this.enricher = new MtomResponseEnricher(ops);
    }

    @Test
    public void enrich() throws Exception {
        String result;
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:attachment-id\"/></attachment></con:downloadAttachmentResponse>";
        StringReader reader = new StringReader(response);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader responseXmlReader = factory.createXMLStreamReader(reader);
        ExchangeImpl exchange = new ExchangeImpl();
        try (InputStream enrichedResponse = this.enricher.enrich(responseXmlReader, "downloadAttachment", (Exchange)exchange);){
            result = IOUtils.toString((InputStream)enrichedResponse, (Charset)StandardCharsets.UTF_8);
        }
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
    }

    @Test
    public void enrichAddLasedAttachments() throws Exception {
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment>SGkgdGhlcmU=</attachment></con:downloadAttachmentResponse>";
        StringReader reader = new StringReader(response);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader responseXmlReader = factory.createXMLStreamReader(reader);
        ExchangeImpl exchange = new ExchangeImpl();
        try (InputStream enrichedResponse = this.enricher.enrich(responseXmlReader, "downloadAttachment", (Exchange)exchange);){
            String result = IOUtils.toString((InputStream)enrichedResponse, (Charset)StandardCharsets.UTF_8);
        }
        Map soapAttachmentMap = (Map)exchange.get((Object)"mule.soap.attachments");
        byte[] attachment = new byte[8];
        ((SoapAttachment)soapAttachmentMap.get("attachment")).getContent().read(attachment);
        MatcherAssert.assertThat((Object)attachment, (Matcher)Matchers.is((Object)"Hi there".getBytes()));
    }

    @Test
    public void enrichPreservePreviousAttachments() throws Exception {
        String INLINE_ATTACHMENT_DATA = "Hi there";
        String PREVIOUS_ATTACHMENT_DATA = "previousAttachment";
        String encodedInlineAttachment = Base64.encode((byte[])"Hi there".getBytes());
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment>" + encodedInlineAttachment + "</attachment></con:downloadAttachmentResponse>";
        StringReader reader = new StringReader(response);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader responseXmlReader = factory.createXMLStreamReader(reader);
        ExchangeImpl exchange = new ExchangeImpl();
        HashMap<String, SoapAttachment> attachments = new HashMap<String, SoapAttachment>();
        attachments.put("previousAttachment", new SoapAttachment((InputStream)new ByteArrayInputStream("previousAttachment".getBytes()), "previousAttachment"));
        exchange.put("mule.soap.attachments", attachments);
        this.enricher.enrich(responseXmlReader, "downloadAttachment", (Exchange)exchange);
        Map soapAttachmentMap = (Map)exchange.get((Object)"mule.soap.attachments");
        byte[] enrichedInlineAttachment = new byte["Hi there".length()];
        ((SoapAttachment)soapAttachmentMap.get("attachment")).getContent().read(enrichedInlineAttachment);
        MatcherAssert.assertThat((Object)enrichedInlineAttachment, (Matcher)Matchers.is((Object)"Hi there".getBytes()));
        byte[] enrichedPreviousAttachment = new byte["previousAttachment".length()];
        ((SoapAttachment)soapAttachmentMap.get("previousAttachment")).getContent().read(enrichedPreviousAttachment);
        MatcherAssert.assertThat((Object)enrichedPreviousAttachment, (Matcher)Matchers.is((Object)"previousAttachment".getBytes()));
    }
}

