/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.client.TestSoapClient;

public class ParseResponseTestCase
extends AbstractSoapServiceTestCase {
    private final Map<String, String> transportHeaders = ImmutableMap.builder().put((Object)"Content-Type", (Object)"text/xml").build();

    @Test
    public void simpleOperation() throws Exception {
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getEchoFullResponse().getBytes()), this.transportHeaders);
        this.testParseSimpleOperation(this.client, transportResponse);
    }

    @Test
    public void echoWithLocalWsdl() throws Exception {
        URL wsdl = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        TestSoapClient localWsdlClient = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withWsdlLocation(wsdl.getPath()).withVersion(this.soapVersion).build());
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getEchoFullResponse().getBytes()), this.transportHeaders);
        this.testParseSimpleOperation(localWsdlClient, transportResponse);
    }

    @Test
    public void simpleOperationWithHeaders() throws Exception {
        ImmutableMap soapHeaders = ImmutableMap.builder().put((Object)"headerOut", (Object)this.testValues.getHeaderOut()).put((Object)"headerInOut", (Object)this.testValues.getHeaderInOutResponse()).build();
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getEchoWithHeadersFullResponse((Map<String, String>)soapHeaders).getBytes()), this.transportHeaders);
        SoapResponse response = this.client.parseResponse("echoWithHeaders", transportResponse);
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerOut"), this.testValues.getHeaderOut());
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerInOut"), this.testValues.getHeaderInOutResponse());
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoWithHeadersResponse(), response.getContent());
    }

    @Test
    public void complexTypeOperation() throws Exception {
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getEchoAccoutFullResponse().getBytes()), this.transportHeaders);
        SoapResponse response = this.client.parseResponse("echoAccount", transportResponse);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoAccountResponse(), response.getContent());
    }

    @Test
    public void noParamsOperation() throws Exception {
        ImmutableMap transportHeaders = ImmutableMap.builder().put((Object)"Content-Type", (Object)"text/xml").build();
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getNoParamsFullResponse().getBytes()), (Map)transportHeaders);
        SoapResponse response = this.client.parseResponse("noParams", transportResponse);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getNoParamsResponse(), response.getContent());
    }

    @Test
    public void large() throws Exception {
        String operation = "large";
        String largeContent = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResource("large.json").openStream());
        String xmlBody = this.testValues.buildXml(operation + "Response", "<largeResponse>" + largeContent + "</largeResponse>");
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.buildFullResponseXml(xmlBody, Collections.emptyMap()).getBytes()), this.transportHeaders);
        SoapResponse response = this.client.parseResponse(operation, transportResponse);
        SoapTestUtils.assertSimilarXml(xmlBody, response.getContent());
    }

    @Test
    public void transportHeaders() {
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getEchoFullResponse().getBytes()), this.transportHeaders);
        SoapResponse response = this.client.parseResponse("echo", transportResponse);
        MatcherAssert.assertThat(response.getTransportHeaders().entrySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)response.getTransportHeaders().containsKey("Content-Type"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(response.getTransportHeaders().get("Content-Type"), (Matcher)Is.is((Object)"text/xml"));
    }

    @Test
    public void transportAdditionalData() {
        TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getEchoFullResponse().getBytes()), this.transportHeaders);
        SoapResponse response = this.client.parseResponse("echo", transportResponse);
        MatcherAssert.assertThat(response.getTransportAdditionalData().entrySet(), (Matcher)Matchers.hasSize((int)0));
    }

    private void testParseSimpleOperation(SoapClient client, TransportResponse transportResponse) throws Exception {
        SoapResponse response = client.parseResponse("echo", transportResponse);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoResponse(), response.getContent());
    }
}

