/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringContains;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.exception.SoapFaultException;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.transport.TransportResponse;

public class SoapFaultTestCase
extends AbstractSoapServiceTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void failOperation() throws Exception {
        try {
            this.client.consume((SoapRequest)SoapRequest.builder().content(this.testValues.getFailRequest()).operation("fail").build(), null);
        }
        catch (SoapFaultException e) {
            this.assertSoapFaultException(e);
        }
    }

    @Test
    public void parseOperationOfFailOperation() throws Exception {
        try {
            HashMap<String, String> transportHeaders = new HashMap<String, String>();
            transportHeaders.put("Content-Type", "text/xml");
            TransportResponse transportResponse = new TransportResponse((InputStream)new ByteArrayInputStream(this.testValues.getFailFullResponse().getBytes()), transportHeaders);
            this.client.parseResponse("fail", transportResponse);
        }
        catch (SoapFaultException e) {
            this.assertSoapFaultException(e);
        }
    }

    @Test
    public void noExistentOperation() throws Exception {
        this.expectedException.expect(BadRequestException.class);
        this.expectedException.expectMessage("The provided operation [FAIL] does not exist in the WSDL file");
        this.client.consume((SoapRequest)SoapRequest.builder().content(this.testValues.buildXml("FAIL", "")).operation("FAIL").build(), null);
    }

    @Test
    public void echoBodyIsNotValidXml() throws Exception {
        this.expectedException.expect(BadRequestException.class);
        this.expectedException.expectMessage("Error consuming the operation [echo], the request body is not a valid XML");
        this.client.consume((SoapRequest)SoapRequest.builder().operation("echo").content("Invalid Test Payload: this is not an XML").build(), null);
    }

    private void assertSoapFaultException(SoapFaultException e) {
        MatcherAssert.assertThat((Object)e.getFaultCode().getLocalPart(), (Matcher)Matchers.isOneOf((Object[])new String[]{"Server", "Receiver"}));
        MatcherAssert.assertThat((Object)e.getReason(), (Matcher)Is.is((Object)"Fail Message"));
        MatcherAssert.assertThat((Object)e.getDetail(), (Matcher)StringContains.containsString((String)"EchoException"));
        MatcherAssert.assertThat((Object)e.getDetail(), (Matcher)StringContains.containsString((String)"Fail Message"));
    }
}

