/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.rm.TerminateSequenceRequest;
import org.mule.soap.api.transport.DispatcherException;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.service.RM11Service;
import org.mule.soap.service.RM12Service;

public class NegativeTerminateSequenceTestCase
extends AbstractSoapServiceTestCase {
    private static final String namespaceUri = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected String getServiceClass() {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? RM11Service.class.getName() : RM12Service.class.getName();
    }

    @Test
    public void failTerminateSequenceWithInvalidDispatcherTest() {
        this.expectedException.expect(DispatcherException.class);
        String sid = this.client.createSequence(CreateSequenceRequest.builder().namespaceUri(namespaceUri).build(), null);
        this.client.terminateSequence(TerminateSequenceRequest.builder().sequenceIdentifier(sid).build(), new FailTransportDispatcher());
    }

    @Test
    public void failTerminateSequenceWithInvalidSequenceIdentifierTest() {
        this.expectedException.expect(BadRequestException.class);
        this.client.terminateSequence(TerminateSequenceRequest.builder().sequenceIdentifier("Sarasa").build(), null);
    }

    private static class FailTransportDispatcher
    implements TransportDispatcher {
        private FailTransportDispatcher() {
        }

        public TransportResponse dispatch(TransportRequest request) throws DispatcherException {
            throw new DispatcherException("Fail Transport dispatcher", (Throwable)new RuntimeException());
        }
    }
}

