/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm.store;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.PersistenceUtils;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.soap.api.rm.ReliableMessagingStore;
import org.mule.soap.internal.rm.store.RMStoreImp;

public class RmStoreImpTestCase {
    private final TestReliableMessagingStore testReliableMessagingStore = new TestReliableMessagingStore();
    private final RMStore rmStore = new RMStoreImp((ReliableMessagingStore)this.testReliableMessagingStore);

    @Before
    public void setup() throws Exception {
        this.testReliableMessagingStore.clear();
    }

    @Test
    public void createSourceSequenceAndGetSourceSequence() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.createSourceSequence(sourceSequence);
        SourceSequence storedSourceSequence = this.rmStore.getSourceSequence(sourceSequence.getIdentifier());
        this.assertSourceSequenceEquals(storedSourceSequence, sourceSequence);
    }

    @Test
    public void createDestinationSequenceAndGetDestinationSequence() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        this.rmStore.createDestinationSequence(destinationSequence);
        DestinationSequence storedDestinationSequence = this.rmStore.getDestinationSequence(destinationSequence.getIdentifier());
        this.assertDestinationSequenceEquals(storedDestinationSequence, destinationSequence);
    }

    @Test
    public void removeSourceSequence() {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.createSourceSequence(sourceSequence);
        this.rmStore.removeSourceSequence(sourceSequence.getIdentifier());
        MatcherAssert.assertThat((Object)this.rmStore.getSourceSequence(sourceSequence.getIdentifier()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void removeDestinationSequence() {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        this.rmStore.createDestinationSequence(destinationSequence);
        this.rmStore.removeDestinationSequence(destinationSequence.getIdentifier());
        MatcherAssert.assertThat((Object)this.rmStore.getDestinationSequence(destinationSequence.getIdentifier()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void persistOutgoing() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.createSourceSequence(sourceSequence);
        RMMessage rmMessage = this.createRMMessage();
        this.rmStore.persistOutgoing(sourceSequence, rmMessage);
        RMMessage storedRmMessage = (RMMessage)this.rmStore.getMessages(sourceSequence.getIdentifier(), true).iterator().next();
        this.assertMessageEquals(storedRmMessage, rmMessage);
    }

    @Test
    public void persistIncoming() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        this.rmStore.createDestinationSequence(destinationSequence);
        RMMessage rmMessage = this.createRMMessage();
        this.rmStore.persistIncoming(destinationSequence, rmMessage);
        RMMessage storedRmMessage = (RMMessage)this.rmStore.getMessages(destinationSequence.getIdentifier(), false).iterator().next();
        this.assertMessageEquals(storedRmMessage, rmMessage);
    }

    @Test
    public void removeMessagesOutbound() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.createSourceSequence(sourceSequence);
        RMMessage rmMessage = this.createRMMessage();
        this.rmStore.persistOutgoing(sourceSequence, rmMessage);
        ArrayList<Long> messageNumbers = new ArrayList<Long>();
        messageNumbers.add(rmMessage.getMessageNumber());
        this.rmStore.removeMessages(sourceSequence.getIdentifier(), messageNumbers, true);
        Collection rmMessages = this.rmStore.getMessages(sourceSequence.getIdentifier(), true);
        MatcherAssert.assertThat((Object)rmMessages, (Matcher)Matchers.empty());
    }

    @Test
    public void removeMessagesInbound() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        this.rmStore.createDestinationSequence(destinationSequence);
        RMMessage rmMessage = this.createRMMessage();
        this.rmStore.persistIncoming(destinationSequence, rmMessage);
        ArrayList<Long> messageNumbers = new ArrayList<Long>();
        messageNumbers.add(rmMessage.getMessageNumber());
        this.rmStore.removeMessages(destinationSequence.getIdentifier(), messageNumbers, false);
        Collection rmMessages = this.rmStore.getMessages(destinationSequence.getIdentifier(), false);
        MatcherAssert.assertThat((Object)rmMessages, (Matcher)Matchers.empty());
    }

    private SourceSequence createSourceSequence() {
        Identifier identifier = new Identifier();
        identifier.setValue("seq");
        Date expires = new Date();
        Identifier offeringIdentifier = new Identifier();
        offeringIdentifier.setValue("offeringId");
        return new SourceSequence(identifier, expires, offeringIdentifier, 1L, false, ProtocolVariation.RM10WSA200408);
    }

    private DestinationSequence createDestinationSequence() {
        Identifier identifier = new Identifier();
        identifier.setValue("seq");
        EndpointReferenceType endpointReferenceType = RMUtils.createReference((String)"http://localhost:9999/");
        return new DestinationSequence(identifier, endpointReferenceType, null, ProtocolVariation.RM10WSA200408);
    }

    private RMMessage createRMMessage() throws Exception {
        RMMessage rmMessage = new RMMessage();
        InputStream fis = this.getClass().getResourceAsStream("SerializedRMMessage.txt");
        CachedOutputStream cos = new CachedOutputStream();
        IOUtils.copyAndCloseInput((InputStream)fis, (OutputStream)cos);
        cos.flush();
        rmMessage.setContent(cos);
        rmMessage.setContentType("text/xml");
        rmMessage.setTo("toAddress");
        rmMessage.setMessageNumber(1L);
        rmMessage.setCreatedTime(System.currentTimeMillis());
        return rmMessage;
    }

    private void assertSourceSequenceEquals(SourceSequence actualSourceSequence, SourceSequence expectedSourceSequence) {
        if (!actualSourceSequence.getIdentifier().getValue().equals(expectedSourceSequence.getIdentifier().getValue())) {
            throw new AssertionError();
        }
        if (!actualSourceSequence.getExpires().equals(expectedSourceSequence.getExpires())) {
            throw new AssertionError();
        }
        if (actualSourceSequence.getCurrentMessageNr() != expectedSourceSequence.getCurrentMessageNr()) {
            throw new AssertionError();
        }
        if (actualSourceSequence.isLastMessage() != expectedSourceSequence.isLastMessage()) {
            throw new AssertionError();
        }
        if (!actualSourceSequence.getOfferingSequenceIdentifier().getValue().equals(expectedSourceSequence.getOfferingSequenceIdentifier().getValue())) {
            throw new AssertionError();
        }
    }

    private void assertDestinationSequenceEquals(DestinationSequence actualDestinationSequence, DestinationSequence expectedDestinationSequence) throws Exception {
        if (!actualDestinationSequence.getIdentifier().getValue().equals(expectedDestinationSequence.getIdentifier().getValue())) {
            throw new AssertionError();
        }
        if (!actualDestinationSequence.getAcksTo().getAddress().getValue().equals(expectedDestinationSequence.getAcksTo().getAddress().getValue())) {
            throw new AssertionError();
        }
        if (actualDestinationSequence.getLastMessageNumber() != expectedDestinationSequence.getLastMessageNumber()) {
            throw new AssertionError();
        }
        if (!RmStoreImpTestCase.encodeProtocolVersion(actualDestinationSequence.getProtocol()).equals(RmStoreImpTestCase.encodeProtocolVersion(expectedDestinationSequence.getProtocol()))) {
            throw new AssertionError();
        }
        if (actualDestinationSequence.isTerminated() != expectedDestinationSequence.isTerminated()) {
            throw new AssertionError();
        }
        SequenceAcknowledgement actualSequenceAcknowledgement = actualDestinationSequence.getAcknowledgment();
        String actualSequenceAcknowledgementValue = IOUtils.toString((InputStream)PersistenceUtils.getInstance().serialiseAcknowledgment(actualSequenceAcknowledgement));
        SequenceAcknowledgement expectedSequenceAcknowledgement = expectedDestinationSequence.getAcknowledgment();
        String expectedSequenceAcknowledgementValue = IOUtils.toString((InputStream)PersistenceUtils.getInstance().serialiseAcknowledgment(expectedSequenceAcknowledgement));
        if (!actualSequenceAcknowledgementValue.equals(expectedSequenceAcknowledgementValue)) {
            throw new AssertionError();
        }
    }

    private void assertMessageEquals(RMMessage actualRMMessage, RMMessage expectedRMMessage) throws Exception {
        String expectedContentString;
        if (!actualRMMessage.getContentType().equals(expectedRMMessage.getContentType())) {
            throw new AssertionError();
        }
        if (actualRMMessage.getMessageNumber() != expectedRMMessage.getMessageNumber()) {
            throw new AssertionError();
        }
        if (!actualRMMessage.getTo().equals(expectedRMMessage.getTo())) {
            throw new AssertionError();
        }
        if (actualRMMessage.getCreatedTime() != expectedRMMessage.getCreatedTime()) {
            throw new AssertionError();
        }
        String actualContentString = IOUtils.toString((InputStream)actualRMMessage.getContent().getInputStream(), (String)StandardCharsets.UTF_8.name());
        if (!actualContentString.equals(expectedContentString = IOUtils.toString((InputStream)expectedRMMessage.getContent().getInputStream(), (String)StandardCharsets.UTF_8.name()))) {
            throw new AssertionError();
        }
    }

    private static String encodeProtocolVersion(ProtocolVariation pro) {
        return pro.getCodec().getWSRMNamespace() + ' ' + pro.getCodec().getWSANamespace();
    }

    public static class TestReliableMessagingStore
    implements ReliableMessagingStore<Serializable> {
        private final Map<String, Serializable> VALUES = new HashMap<String, Serializable>();

        public void store(String s, Serializable serializable) throws Exception {
            if (this.VALUES.containsKey(s)) {
                throw new Exception();
            }
            this.VALUES.put(s, serializable);
        }

        public void update(String key, Serializable value) throws Exception {
            this.VALUES.put(key, value);
        }

        public Serializable retrieve(String key) throws Exception {
            return this.VALUES.get(key);
        }

        public Serializable remove(String key) throws Exception {
            if (!this.VALUES.containsKey(key)) {
                throw new Exception();
            }
            return this.VALUES.remove(key);
        }

        public Map<String, Serializable> retrieveAll() throws Exception {
            return this.VALUES;
        }

        public void clear() throws Exception {
            this.VALUES.clear();
        }
    }
}

