/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.wss;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.security.WssDecryptSecurityStrategy;
import org.mule.soap.api.security.WssIncomingTimestampSecurityStrategy;
import org.mule.soap.api.security.stores.WssKeyStoreConfiguration;
import org.mule.soap.runtime.wss.AbstractWebServiceSecurityTestCase;

public class WssDecryptWithTimestampTestCase
extends AbstractWebServiceSecurityTestCase {
    @Override
    protected Interceptor buildOutInterceptor() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("action", "Timestamp Encrypt");
        props.put("encryptionUser", "s1as");
        String encryptionPropRefId = "securityProperties";
        props.put("encryptionPropRefId", "securityProperties");
        Properties securityProperties = new Properties();
        securityProperties.put("org.apache.ws.security.crypto.merlin.truststore.type", "jks");
        securityProperties.put("org.apache.ws.security.crypto.merlin.truststore.password", "changeit");
        securityProperties.put("org.apache.ws.security.crypto.merlin.truststore.file", "security/ssltest-cacerts.jks");
        props.put("securityProperties", securityProperties);
        return new WSS4JOutInterceptor(props);
    }

    @Override
    protected List<SecurityStrategy> getSecurityStrategies() {
        WssKeyStoreConfiguration ks = new WssKeyStoreConfiguration("s1as", "changeit", "security/ssltest-keystore.jks", "changeit", "jks");
        return Arrays.asList(new WssDecryptSecurityStrategy(ks), new WssIncomingTimestampSecurityStrategy(60L));
    }
}

