/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.soap.internal.interceptor.gzip.ProxyGZIPInInterceptor;
import org.mule.soap.internal.interceptor.gzip.ProxyGZIPOutInterceptor;
import org.mule.soap.internal.util.DelegatingOutputStream;

public class GZIPFeatureTestCase {
    String data = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.soap.service.mule.org/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <ser:echoResponse>\n         <text>Some Cool GZIPped Content</text>\n      </ser:echoResponse>\n   </soapenv:Body>\n</soapenv:Envelope>";
    byte[] compressedData = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0, 109, -112, 65, 10, -62, 48, 16, 69, -9, -98, 34, -12, 0, -99, 125, -120, 93, 40, -94, -18, 68, 119, -18, 66, -5, -79, 66, -110, 9, 73, 44, -11, -10, -74, -95, -95, 20, -36, -51, -1, -113, 55, 19, -94, 34, 107, 15, 55, -56, -109, 27, 96, -40, 67, -116, -42, -72, 40, -105, 122, 95, -11, 41, 121, 73, 20, -37, 30, 86, -57, 122, -94, 51, -86, 57, -68, 104, 30, 8, -117, 71, 85, 49, 17, 86, 11, 97, 120, -73, -88, -77, 82, -126, -3, 24, 100, -65, 106, 118, 66, 8, 85, 94, 112, -127, -18, 16, 104, 91, 30, -72, -5, -26, 38, -105, 8, 18, 109, -49, 119, 68, -49, 46, -94, -128, -103, 37, -116, -87, 121, -80, -123, 56, 50, 27, 113, 126, 94, 111, 30, -35, 20, 92, -126, 75, -118, 50, 47, -117, -24, -17, 38, 69, -37, -85, 107, 46, -97, -45, -4, 0, 61, 108, 120, 14, 47, 1, 0, 0};

    @Test
    public void testOutgoingMessage() throws IOException {
        ProxyGZIPOutInterceptor proxyGZIPOutInterceptor = new ProxyGZIPOutInterceptor();
        Message outgoingMessage = this.getOutgoingMessageMock(this.data.getBytes());
        proxyGZIPOutInterceptor.handleMessage(outgoingMessage);
        ByteArrayOutputStream outputStream = ((DelegatingOutputStream)outgoingMessage.getContent(DelegatingOutputStream.class)).getOutputStream();
        MatcherAssert.assertThat((Object)this.isCompressed(outputStream.toByteArray()), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)outputStream.toByteArray(), (Matcher)Is.is((Object)this.compressedData));
    }

    @Test
    public void testIncomingMessage() throws IOException {
        ProxyGZIPInInterceptor proxyGZIPInInterceptor = new ProxyGZIPInInterceptor();
        Message incomingMessage = this.getIncomingMessageMock(this.compressedData);
        proxyGZIPInInterceptor.handleMessage(incomingMessage);
        InputStream uncompressedData = (InputStream)incomingMessage.getContent(InputStream.class);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)uncompressedData, (Writer)writer, (String)"UTF-8");
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)Is.is((Object)this.data));
    }

    private Message getOutgoingMessageMock(byte[] content) throws IOException {
        Exchange exchangeMock = (Exchange)Mockito.mock(Exchange.class);
        DelegatingOutputStream os = new DelegatingOutputStream();
        os.write(content);
        Mockito.when((Object)exchangeMock.get((Object)"mule.soap.transport.headers")).thenReturn(Collections.singletonMap("Content-Encoding", "gzip"));
        MessageImpl message = new MessageImpl();
        message.setContent(OutputStream.class, (Object)os);
        message.setContent(DelegatingOutputStream.class, (Object)os);
        message.setExchange(exchangeMock);
        return message;
    }

    private Message getIncomingMessageMock(byte[] content) {
        Exchange exchangeMock = (Exchange)Mockito.mock(Exchange.class);
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        Mockito.when((Object)exchangeMock.get((Object)"mule.soap.transport.headers")).thenReturn(Collections.singletonMap("Content-Encoding", "gzip"));
        MessageImpl message = new MessageImpl();
        message.setContent(InputStream.class, (Object)is);
        message.setExchange(exchangeMock);
        return message;
    }

    private boolean isCompressed(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

