/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.unit;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.MessageObserver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.interceptor.MessageDispatcherInterceptor;
import org.mule.soap.internal.util.DelegatingOutputStream;

public class MessageDispatcherInterceptorTestCase {
    private MessageDispatcherInterceptor messageDispatcherInterceptor;
    private MessageObserver messageObserver = new MessageObserverTest();

    @Before
    public void setup() {
        this.messageDispatcherInterceptor = new MessageDispatcherInterceptor(this.messageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void charsetFromResponseIsSetOnCXFMessage() throws Exception {
        try (DelegatingOutputStream outputStream = null;){
            Message messageSpy = (Message)Mockito.spy((Object)new MessageImpl());
            Exchange exchangeMock = (Exchange)Mockito.mock(Exchange.class);
            InterceptorChain interceptorChainMock = (InterceptorChain)Mockito.mock(InterceptorChain.class);
            TransportDispatcher transportDispatcherMock = (TransportDispatcher)Mockito.mock(TransportDispatcher.class);
            TransportResponse transportResponseMock = (TransportResponse)Mockito.mock(TransportResponse.class);
            outputStream = new DelegatingOutputStream();
            outputStream.write("Hello".getBytes(StandardCharsets.UTF_8));
            Mockito.when((Object)messageSpy.getExchange()).thenReturn((Object)exchangeMock);
            Mockito.when((Object)messageSpy.getContent(DelegatingOutputStream.class)).thenReturn((Object)outputStream);
            Mockito.when((Object)messageSpy.getInterceptorChain()).thenReturn((Object)interceptorChainMock);
            Mockito.when((Object)interceptorChainMock.doIntercept(messageSpy)).thenReturn((Object)true);
            Mockito.when((Object)exchangeMock.get((Object)"mule.soap.dispatcher")).thenReturn((Object)transportDispatcherMock);
            Mockito.when((Object)exchangeMock.get((Object)"mule.soap.transport.headers")).thenReturn(Collections.emptyMap());
            Mockito.when((Object)transportDispatcherMock.dispatch((TransportRequest)ArgumentMatchers.any())).thenReturn((Object)transportResponseMock);
            Mockito.when((Object)transportResponseMock.getContentType()).thenReturn((Object)"text/plain; charset=ISO-8859-7");
            this.messageDispatcherInterceptor.handleMessage(messageSpy);
            Assert.assertThat((Object)((MessageObserverTest)this.messageObserver).getEncoding(), (Matcher)CoreMatchers.is((Object)"ISO-8859-7"));
        }
    }

    private class MessageObserverTest
    implements MessageObserver {
        private String encoding;

        private MessageObserverTest() {
        }

        public void onMessage(Message message) {
            this.encoding = (String)message.get((Object)Message.ENCODING);
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

