/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.message;

import java.util.Optional;

/**
 * Representation of Message Addressing Properties
 *
 * @since 1.6
 */
public interface AddressingProperties {

  /**
   * @return the namespace URL of the WS-A version.
   */
  String getNamespace();

  /**
   * @return an identifier that uniquely identifies the semantics implied by this message.
   */
  String getAction();

  /**
   * @return the destination endpoint URL.
   */
  String getTo();

  /**
   * @return the source endpoint URL.
   */
  Optional<String> getFrom();

  /**
   * @return the message identifier
   */
  Optional<String> getMessageId();

  /**
   * @return the identifier of the related message.
   */
  Optional<String> getRelatesTo();
}
