package org.mule.soap.internal.rm;

import java.util.Timer;

import javax.xml.namespace.QName;

import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.RedeliveryQueue;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.SequenceIdentifierGenerator;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.manager.RM10AddressingNamespaceType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rmp.v200502.RMAssertion;

public class ForwardingRMManager extends RMManager {

  private final RMManager manager;

  public ForwardingRMManager(RMManager manager) {
    this.manager = manager;
  }

  @Override
  public void startServer(Server server) {
    manager.startServer(server);
  }

  @Override
  public void stopServer(Server server) {
    manager.stopServer(server);
  }

  @Override
  public void clientCreated(Client client) {
    manager.clientCreated(client);
  }

  @Override
  public void clientDestroyed(Client client) {
    manager.clientDestroyed(client);
  }

  @Override
  public void setRMNamespace(String uri) {
    manager.setRMNamespace(uri);
  }

  @Override
  public void setRM10AddressingNamespace(RM10AddressingNamespaceType addrns) {
    manager.setRM10AddressingNamespace(addrns);
  }

  @Override
  public Bus getBus() {
    return manager.getBus();
  }

  @Override
  public void setBus(Bus b) {
    manager.setBus(b);
  }

  @Override
  public RMStore getStore() {
    return manager.getStore();
  }

  @Override
  public void setStore(RMStore s) {
    manager.setStore(s);
  }

  @Override
  public RetransmissionQueue getRetransmissionQueue() {
    return manager.getRetransmissionQueue();
  }

  @Override
  public void setRetransmissionQueue(RetransmissionQueue rq) {
    manager.setRetransmissionQueue(rq);
  }

  @Override
  public RedeliveryQueue getRedeliveryQueue() {
    return manager.getRedeliveryQueue();
  }

  @Override
  public void setRedeliveryQueue(RedeliveryQueue redeliveryQueue) {
    manager.setRedeliveryQueue(redeliveryQueue);
  }

  @Override
  public SequenceIdentifierGenerator getIdGenerator() {
    return manager.getIdGenerator();
  }

  @Override
  public void setIdGenerator(SequenceIdentifierGenerator generator) {
    manager.setIdGenerator(generator);
  }

  @Override
  public Timer getTimer() {
    return manager.getTimer();
  }

  @Override
  public BindingFaultFactory getBindingFaultFactory(Binding binding) {
    return manager.getBindingFaultFactory(binding);
  }

  @Override
  public void setDeliveryAssurance(DeliveryAssuranceType dat) {
    manager.setDeliveryAssurance(dat);
  }

  @Override
  public DestinationPolicyType getDestinationPolicy() {
    return manager.getDestinationPolicy();
  }

  @Override
  public void setDestinationPolicy(DestinationPolicyType destinationPolicy) {
    manager.setDestinationPolicy(destinationPolicy);
  }

  @Override
  public RMConfiguration getConfiguration() {
    return manager.getConfiguration();
  }

  @Override
  public void setConfiguration(RMConfiguration configuration) {
    manager.setConfiguration(configuration);
  }

  @Override
  public RMConfiguration getEffectiveConfiguration(Message msg) {
    return manager.getEffectiveConfiguration(msg);
  }

  @Override
  public void setRMAssertion(RMAssertion rma) {
    manager.setRMAssertion(rma);
  }

  @Override
  public SourcePolicyType getSourcePolicy() {
    return manager.getSourcePolicy();
  }

  @Override
  public void setSourcePolicy(SourcePolicyType sp) {
    manager.setSourcePolicy(sp);
  }

  @Override
  public RMEndpoint getReliableEndpoint(Message message) throws RMException {
    return manager.getReliableEndpoint(message);
  }

  @Override
  public RMEndpoint findReliableEndpoint(QName qn) {
    return manager.findReliableEndpoint(qn);
  }

  @Override
  public Destination getDestination(Message message) throws RMException {
    return manager.getDestination(message);
  }

  @Override
  public Source getSource(Message message) throws RMException {
    return manager.getSource(message);
  }

  @Override
  public SourceSequence getSequence(Identifier inSeqId, Message message, AddressingProperties maps) throws RMException {
    return manager.getSequence(inSeqId, message, maps);
  }

  @Override
  public void shutdown() {
    manager.shutdown();
  }

  @Override
  public void init(Bus b) {
    manager.init(b);
  }

  @Override
  public void initializeInterceptorChain(Message msg) {
    manager.initializeInterceptorChain(msg);
  }

  @Override
  public PhaseInterceptorChain getRetransmitChain(Message msg) {
    return manager.getRetransmitChain(msg);
  }
}
