/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.message;

import java.util.Collections;
import java.util.Map;

/**
 * Represents a response retrieved by a Soap Web Service. Carries additional information about the transport protocol used.
 *
 * @since 1.0
 */
public interface SoapResponse extends SoapMessage {

  /**
   * @return a map of Additional Data that is transport specific.
   *
   * @since 1.0.1
   */
  default Map<String, String> getTransportAdditionalData() {
    return Collections.emptyMap();
  }

}
