package org.mule.soap.api.rm;

import java.io.Serializable;

/**
 * Represents a Reliable Messaging Configuration with all the required attributes to use WSRM
 *
 * @since 1.6
 */
public class ReliableMessagingConfiguration {

  private final ReliableMessagingStore<Serializable> store;

  ReliableMessagingConfiguration(ReliableMessagingStore<Serializable> store) {
    this.store = store;
  }

  public static ReliableMessagingConfigurationBuilder builder() {
    return new ReliableMessagingConfigurationBuilder();
  }

  /**
   * Gets the reliable messaging store.
   */
  public ReliableMessagingStore<Serializable> getStore() {
    return store;
  }

}
