/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.rm;

import static com.google.common.base.Preconditions.checkNotNull;

import java.io.Serializable;

/**
 * Builder pattern implementation that creates {@link ReliableMessagingConfiguration} instances.
 *
 * @since 1.6
 */
public class ReliableMessagingConfigurationBuilder {

  private ReliableMessagingStore<Serializable> store;

  ReliableMessagingConfigurationBuilder() {}

  public ReliableMessagingConfigurationBuilder store(ReliableMessagingStore<Serializable> store) {
    this.store = store;
    return this;
  }

  public ReliableMessagingConfiguration build() {
    checkNotNull(store, "Store cannot be null");
    return new ReliableMessagingConfiguration(store);
  }
}
