package org.mule.soap.api.transport;

import java.io.InputStream;
import java.util.Map;

/**
 * Request message used to send data through a transport.
 *
 * @since 1.0
 */
public class TransportRequest extends TransportMessage {

  private final String address;

  public TransportRequest(InputStream message, String address, Map<String, String> headers) {
    super(message, headers);
    this.address = address;
  }

  public String getAddress() {
    return this.address;
  }
}
