/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.exception;

import org.mule.soap.api.rm.ReliableMessagingStore;

import java.util.Map;

/**
 * {@link Exception} implementation that aims to be thrown when an error occurs storing a RM sequence on the
 * {@link ReliableMessagingStore}.
 *
 * @since 1.6
 */
public class ReliableMessagingStoreException extends RuntimeException {

  private Map<String, String> additionalTransportData;

  public ReliableMessagingStoreException(String message) {
    super(message);
  }

  public ReliableMessagingStoreException(String message, Throwable cause) {
    super(message, cause);
  }

  public ReliableMessagingStoreException(String message, Throwable cause, Map<String, String> additionalTransportData) {
    super(message, cause);
    this.additionalTransportData = additionalTransportData;
  }
}
