package org.mule.soap.api.transport;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

/**
 * Response message used to retrieve data received from a custom transport call.
 *
 * @since 1.0
 */
public class TransportResponse extends TransportMessage {

  private final Map<String, String> additionalData;

  /**
   * Creates a transport response when no transport specific data is available.
   *
   * @since 1.0.0
   */
  public TransportResponse(InputStream message, Map<String, String> headers) {
    super(message, headers);
    this.additionalData = Collections.emptyMap();
  }

  /**
   * Creates a transport response with transport specific data.
   *
   * @since 1.0.1
   */
  public TransportResponse(InputStream message, Map<String, String> headers, Map<String, String> additionalData) {
    super(message, headers);
    this.additionalData = additionalData;
  }

  /**
   * @return a map of Additional Data that is transport specific.
   *
   * @since 1.0.1
   */
  public Map<String, String> getAdditionalData() {
    return this.additionalData;
  }
}
