/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm.store;

import java.io.Serializable;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.exception.ReliableMessagingStoreException;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.rm.ReliableMessagingConfiguration;
import org.mule.soap.api.rm.ReliableMessagingStore;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.runtime.rm.RMExecutionTestCase;
import org.mule.soap.service.RM11Service;
import org.mule.soap.service.RM12Service;
import org.mule.soap.transport.TestHttpDispatcher;

public class NegativeCreateSequenceWithStoreTestCase
extends AbstractSoapServiceTestCase {
    private static final String namespaceUri = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    private RMExecutionTestCase.TestRMHttpDispatcher rmDispatcher;
    private ReliableMessagingStore<Serializable> brokenReliableMessagingStore = (ReliableMessagingStore)Mockito.mock(ReliableMessagingStore.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected String getServiceClass() {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? RM11Service.class.getName() : RM12Service.class.getName();
    }

    @Override
    protected void doBefore() throws Exception {
        this.rmDispatcher = new RMExecutionTestCase.TestRMHttpDispatcher(new TestHttpDispatcher());
        ((ReliableMessagingStore)Mockito.doThrow(ReliableMessagingStoreException.class).when(this.brokenReliableMessagingStore)).store(ArgumentMatchers.anyString(), (Serializable)ArgumentMatchers.any());
    }

    @Test
    public void failCreateSequenceWhenReliableMessagingStoreFails() throws Exception {
        this.expectedException.expect(ReliableMessagingStoreException.class);
        this.expectedException.expectMessage("Unable to create RM sequence");
        ReliableMessagingConfiguration reliableMessaging = ReliableMessagingConfiguration.builder().store(this.brokenReliableMessagingStore).build();
        TestSoapClient client = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).enableMtom(this.isMtom()).withVersion(this.soapVersion).withSecurities(this.getSecurityStrategies()).withReliableMessaging(reliableMessaging).build());
        client.createSequence(CreateSequenceRequest.builder().namespaceUri(namespaceUri).build(), this.rmDispatcher);
    }
}

