/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security.stores;

import java.util.Properties;
import org.apache.wss4j.common.crypto.Merlin;
import org.mule.soap.api.security.stores.WssStoreConfiguration;

public class WssKeyStoreConfiguration
implements WssStoreConfiguration {
    private final String alias;
    private final String keyPassword;
    private final String password;
    private final String keyStorePath;
    private final String type;

    public WssKeyStoreConfiguration(String alias, String password, String keyStorePath, String keyPassword, String type) {
        this.alias = alias;
        this.keyPassword = keyPassword;
        this.password = password;
        this.keyStorePath = keyStorePath;
        this.type = type;
    }

    public WssKeyStoreConfiguration(String alias, String password, String keyStorePath) {
        this.alias = alias;
        this.password = password;
        this.keyStorePath = keyStorePath;
        this.keyPassword = null;
        this.type = "jks";
    }

    @Override
    public Properties getConfigurationProperties() {
        Properties properties = new Properties();
        properties.setProperty("org.apache.wss4j.crypto.provider", Merlin.class.getCanonicalName());
        properties.setProperty("org.apache.wss4j.crypto.merlin.keystore.type", this.type);
        if (this.password != null) {
            properties.setProperty("org.apache.wss4j.crypto.merlin.keystore.password", this.password);
        }
        if (this.alias != null) {
            properties.setProperty("org.apache.wss4j.crypto.merlin.keystore.alias", this.alias);
        }
        if (this.keyStorePath != null) {
            properties.setProperty("org.apache.wss4j.crypto.merlin.keystore.file", this.keyStorePath);
        }
        if (this.keyPassword != null) {
            properties.setProperty("keystore.private.password", this.keyPassword);
        }
        return properties;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getPassword() {
        return this.password;
    }
}

