package org.mule.soap.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

/**
 * This class allows converting an OutputStream into an InputStream without having a duplicated buffer in memory at any time.
 */
public class CopyStream extends ByteArrayOutputStream {

  /**
   * Get an input stream based on the contents of this output stream. Do not use the output stream after calling this method.
   * Consider the output stream as closed after using this method.
   * 
   * @return an {@link InputStream}
   */
  public InputStream toInputStream() {
    return new ByteArrayInputStream(this.buf, 0, this.count);
  }
}
