/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.attachment.AttachmentRequestEnricher;

public abstract class AbstractRequestEnricherTestCase
extends AbstractEnricherTestCase {
    @Override
    public void before() throws Exception {
        super.before();
        System.getProperties().setProperty("mule.soap.maxAttributeSize", "524288");
    }

    @Test
    public void enrich() throws Exception {
        SoapAttachment attachment = this.getTestAttachment();
        AttachmentRequestEnricher enricher = this.getEnricher();
        XMLStreamReader request = enricher.enrichRequest("uploadAttachment", (InputStream)new ByteArrayInputStream(this.testValues.getUploadAttachmentRequest().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8.name(), Collections.singletonMap("attachment-id", attachment));
        SoapTestUtils.assertSimilarXml(this.getExpectedResult(), this.getXmlStreamAsString(request));
    }

    @Test(expected=BadRequestException.class)
    public void enrichMaxSizeFail() throws Throwable {
        InputStream targetStream = Thread.currentThread().getContextClassLoader().getResource("bigsize_request.xml").openStream();
        this.getEnricher().enrichRequest("oneWay", targetStream, StandardCharsets.UTF_8.name(), null);
        Assert.fail((String)String.format("FAIL - It didn't receive a BadRequestException - mule.soap.maxAttributeSize =  [%s]", System.getProperty("mule.soap.maxAttributeSize")));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        System.getProperties().remove("mule.soap.maxAttributeSize");
    }

    private SoapAttachment getTestAttachment() {
        SoapAttachment attachment = (SoapAttachment)Mockito.mock(SoapAttachment.class);
        Mockito.when((Object)attachment.getContent()).thenReturn((Object)IOUtils.toInputStream((String)"Some Content"));
        Mockito.when((Object)attachment.getContentType()).thenReturn((Object)"text/plain");
        return attachment;
    }

    protected abstract AttachmentRequestEnricher getEnricher();

    protected abstract String getExpectedResult();
}

