/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * This class allows to keep track of the original OutputStream throughout all CXF' stages.
 */
public class DelegatingOutputStream extends OutputStream {

  private ByteArrayOutputStream outputStream;

  public DelegatingOutputStream() {
    this.outputStream = new ByteArrayOutputStream();
  }

  @Override
  public void write(byte[] b, int off, int len) {
    synchronized (outputStream) {
      outputStream.write(b, off, len);
    }
  }

  @Override
  public void write(byte[] b) throws IOException {
    synchronized (outputStream) {
      outputStream.write(b);
    }
  }

  @Override
  public void write(int b) {
    synchronized (outputStream) {
      outputStream.write(b);
    }
  }

  public ByteArrayOutputStream getOutputStream() {
    return outputStream;
  }

  public void setOutputStream(ByteArrayOutputStream outputStream) {
    this.outputStream = outputStream;
  }
}
