/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api;

/**
 * The versions of the SOAP protocol.
 *
 * @since 1.0
 */
public enum SoapVersion {

  SOAP_11("1.1", "SOAP 1.1 Protocol"), SOAP_12("1.2", "SOAP 1.2 Protocol");

  private final String version;
  private final String protocol;

  SoapVersion(String version, String protocol) {
    this.version = version;
    this.protocol = protocol;
  }

  public String getNumber() {
    return this.version;
  }

  public String getProtocol() {
    return this.protocol;
  }
}
