/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.transport;

import java.io.InputStream;
import java.util.Map;

/**
 * Request message used to send data through a transport.
 *
 * @since 1.0
 */
public class TransportRequest extends TransportMessage {

  private final String address;

  public TransportRequest(InputStream message, String address, Map<String, String> headers) {
    super(message, headers);
    this.address = address;
  }

  public String getAddress() {
    return this.address;
  }
}
