/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.interceptor;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.ws.addressing.impl.MAPAggregatorImpl;
import org.apache.cxf.ws.addressing.soap.MAPCodec;

import static org.mule.soap.internal.rm.RMUtils.isAddressingEnable;

public class SkipAddressingOutInterceptor extends AbstractSoapInterceptor {

  private final MAPCodec mapCodec;
  private final MAPAggregatorImpl mapAggregator;

  public SkipAddressingOutInterceptor(MAPCodec mapCodec, MAPAggregatorImpl mapAggregator) {
    super(SkipAddressingOutInterceptor.class.getName(), "setup");
    this.mapCodec = mapCodec;
    this.mapAggregator = mapAggregator;
  }

  @Override
  public void handleMessage(SoapMessage soapMessage) {
    if (!isAddressingEnable(soapMessage)) {
      soapMessage.getInterceptorChain().remove(mapCodec);
      soapMessage.getInterceptorChain().remove(mapAggregator);
    }
  }
}
