/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.rm;

import java.io.Serializable;

/**
 * Represents a Reliable Messaging Configuration with all the required attributes to use WSRM
 *
 * @since 1.6
 */
public class ReliableMessagingConfiguration {

  private final ReliableMessagingStore<Serializable> store;

  ReliableMessagingConfiguration(ReliableMessagingStore<Serializable> store) {
    this.store = store;
  }

  public static ReliableMessagingConfigurationBuilder builder() {
    return new ReliableMessagingConfigurationBuilder();
  }

  /**
   * Gets the reliable messaging store.
   */
  public ReliableMessagingStore<Serializable> getStore() {
    return store;
  }

}
