/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FipsClassLoaderDelegate
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(FipsClassLoaderDelegate.class);
    private static final String BCPROV_LIB_PATH = "libs/bcprov-jdk18on-1.78.1.jar";
    public static final String MULE_SECURITY_MODEL = "mule.security.model";
    public static final String FIPS_140_2_MODEL = "fips140-2";
    private static final Set<String> FIPS_140_2_SECURITY_LIBRARIES = SetUtils.hashSet((Object[])new String[]{"libs/bcprov-jdk18on-1.78.1.jar"});
    private final ClassLoader theClassLoader;

    public FipsClassLoaderDelegate(ClassLoader parentClassLoader) {
        if (FIPS_140_2_MODEL.equals(System.getProperty(MULE_SECURITY_MODEL))) {
            logger.debug("No dynamic libraries loaded");
            this.theClassLoader = parentClassLoader;
        } else {
            logger.debug("FipsClassLoader in fips140-2 model, loading " + String.join((CharSequence)", ", FIPS_140_2_SECURITY_LIBRARIES) + " libraries: ");
            Iterator<String> securityLibraryPathIterator = FIPS_140_2_SECURITY_LIBRARIES.iterator();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (securityLibraryPathIterator.hasNext()) {
                String libPath = securityLibraryPathIterator.next();
                try {
                    URL resource = FipsClassLoaderDelegate.class.getClassLoader().getResource(libPath);
                    URL url = new URL("jar:file:" + resource.getPath() + "!/");
                    urlList.add(url);
                    logger.debug(libPath + " library loaded");
                }
                catch (IOException e) {
                    logger.debug(libPath + " cannot be loaded", (Throwable)e);
                }
            }
            this.theClassLoader = new URLClassLoader(urlList.toArray(new URL[0]), parentClassLoader);
            logger.debug("Dynamic security libs loaded");
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        logger.debug("loadClass(" + name + ")");
        return this.theClassLoader.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        logger.debug("getResource(" + name + ")");
        return this.theClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        logger.debug("getResource(" + name + ")");
        return this.theClassLoader.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        logger.debug("getResourceAsStream(" + name + ")");
        return this.theClassLoader.getResourceAsStream(name);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        logger.debug("setDefaultAssertionStatus(" + enabled + ")");
        this.theClassLoader.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        logger.debug("setPackageAssertionStatus(" + packageName + ", " + enabled + ")");
        this.theClassLoader.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        logger.debug("setClassAssertionStatus(" + className + ", " + enabled + ")");
        this.theClassLoader.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void clearAssertionStatus() {
        logger.debug("setClassAssertionStatus()");
        this.theClassLoader.clearAssertionStatus();
    }
}

