/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.rm.store;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.persistence.RMStoreException;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.mule.soap.api.rm.ReliableMessagingStore;
import org.mule.soap.internal.rm.RMUtils;
import org.mule.soap.internal.rm.store.DestinationSequenceTransfer;
import org.mule.soap.internal.rm.store.MessageTransfer;
import org.mule.soap.internal.rm.store.SourceSequenceTransfer;

public class RMStoreImp
implements RMStore {
    private final ReliableMessagingStore<Serializable> reliableMessagingStore;

    public RMStoreImp(ReliableMessagingStore<Serializable> reliableMessagingStore) {
        this.reliableMessagingStore = reliableMessagingStore;
    }

    public void createSourceSequence(SourceSequence sourceSequence) {
        try {
            SourceSequenceTransfer sourceSequenceTransfer = new SourceSequenceTransfer(sourceSequence);
            this.reliableMessagingStore.store(sourceSequence.getIdentifier().getValue(), sourceSequenceTransfer);
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public void createDestinationSequence(DestinationSequence destinationSequence) {
        try {
            DestinationSequenceTransfer destinationSequenceTransfer = new DestinationSequenceTransfer(destinationSequence);
            this.reliableMessagingStore.store(destinationSequence.getIdentifier().getValue(), destinationSequenceTransfer);
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public SourceSequence getSourceSequence(Identifier identifier) {
        try {
            SourceSequenceTransfer sourceSequenceTransfer = (SourceSequenceTransfer)this.reliableMessagingStore.retrieve(identifier.getValue());
            if (sourceSequenceTransfer == null) {
                return null;
            }
            return this.convertToSourceSequence(identifier.getValue(), sourceSequenceTransfer);
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public DestinationSequence getDestinationSequence(Identifier identifier) {
        try {
            DestinationSequenceTransfer destinationSequenceTransfer = (DestinationSequenceTransfer)this.reliableMessagingStore.retrieve(identifier.getValue());
            if (destinationSequenceTransfer == null) {
                return null;
            }
            return this.convertToDestinationSequence(identifier.getValue(), destinationSequenceTransfer);
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public void removeSourceSequence(Identifier identifier) {
        try {
            this.reliableMessagingStore.remove(identifier.getValue());
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public void removeDestinationSequence(Identifier identifier) {
        try {
            this.reliableMessagingStore.remove(identifier.getValue());
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public Collection<SourceSequence> getSourceSequences(String s) {
        try {
            ArrayList<SourceSequence> sourceSequences = new ArrayList<SourceSequence>();
            this.reliableMessagingStore.retrieveAll().entrySet().stream().filter(entry -> entry.getValue() instanceof SourceSequenceTransfer && ((SourceSequenceTransfer)entry.getValue()).getEndpointIdentifier().equals(s)).forEach(entry -> sourceSequences.add(this.convertToSourceSequence((String)entry.getKey(), (SourceSequenceTransfer)entry.getValue())));
            return sourceSequences;
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public Collection<DestinationSequence> getDestinationSequences(String s) {
        try {
            ArrayList<DestinationSequence> destinationSequences = new ArrayList<DestinationSequence>();
            this.reliableMessagingStore.retrieveAll().entrySet().stream().filter(entry -> entry.getValue() instanceof DestinationSequenceTransfer && ((DestinationSequenceTransfer)entry.getValue()).getEndpointIdentifier().equals(s)).forEach(entry -> destinationSequences.add(this.convertToDestinationSequence((String)entry.getKey(), (DestinationSequenceTransfer)entry.getValue())));
            return destinationSequences;
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public Collection<RMMessage> getMessages(Identifier identifier, boolean b) {
        try {
            ArrayList<RMMessage> rmMessages = new ArrayList<RMMessage>();
            Serializable serializable = this.reliableMessagingStore.retrieve(identifier.getValue());
            List<MessageTransfer> messageTransfers = serializable instanceof SourceSequenceTransfer ? ((SourceSequenceTransfer)serializable).getMessageTransfers() : ((DestinationSequenceTransfer)serializable).getMessageTransfers();
            for (MessageTransfer messageTransfer : messageTransfers) {
                if (messageTransfer.isOutbound() != b) continue;
                CachedOutputStream stream = new CachedOutputStream();
                stream.write(messageTransfer.getContent());
                RMUtils.copyAndClose(messageTransfer.getContent(), (OutputStream)stream);
                stream.flush();
                RMMessage rmMessage = new RMMessage();
                rmMessage.setMessageNumber(messageTransfer.getMessageNumber());
                rmMessage.setTo(messageTransfer.getTo());
                rmMessage.setCreatedTime(messageTransfer.getCreatedTime());
                rmMessage.setContent(stream);
                rmMessage.setContentType(messageTransfer.getContentType());
                rmMessages.add(rmMessage);
            }
            return rmMessages;
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public void persistOutgoing(SourceSequence sourceSequence, RMMessage rmMessage) {
        try {
            String identifierValue = sourceSequence.getIdentifier().getValue();
            SourceSequenceTransfer sourceSequenceTransfer = (SourceSequenceTransfer)this.reliableMessagingStore.retrieve(identifierValue);
            long currentMessageNumber = sourceSequence.getCurrentMessageNr();
            boolean isLastMessage = sourceSequence.isLastMessage();
            sourceSequenceTransfer.setLastMessage(isLastMessage);
            sourceSequenceTransfer.setCurrentMessageNumber(currentMessageNumber);
            if (rmMessage != null && rmMessage.getContent() != null) {
                sourceSequenceTransfer.addMessageTransfer(new MessageTransfer(rmMessage, true));
            }
            this.reliableMessagingStore.update(identifierValue, sourceSequenceTransfer);
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public void persistIncoming(DestinationSequence destinationSequence, RMMessage rmMessage) {
        try {
            String identifierValue = destinationSequence.getIdentifier().getValue();
            DestinationSequenceTransfer destinationSequenceTransfer = (DestinationSequenceTransfer)this.reliableMessagingStore.retrieve(identifierValue);
            long lastMessageNumber = destinationSequence.getLastMessageNumber();
            boolean terminated = destinationSequence.isTerminated();
            byte[] ack = RMUtils.toByteArray(destinationSequence.getAcknowledgment());
            destinationSequenceTransfer.setLastMessageNumber(lastMessageNumber);
            destinationSequenceTransfer.setTerminate(terminated);
            destinationSequenceTransfer.setAcknowledged(ack);
            if (rmMessage != null && rmMessage.getContent() != null) {
                destinationSequenceTransfer.addMessageTransfer(new MessageTransfer(rmMessage, false));
            }
            this.reliableMessagingStore.update(identifierValue, destinationSequenceTransfer);
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    public void removeMessages(Identifier identifier, Collection<Long> messageNrs, boolean b) {
        try {
            String identifierValue = identifier.getValue();
            Serializable serializable = this.reliableMessagingStore.retrieve(identifierValue);
            if (serializable instanceof SourceSequenceTransfer) {
                List<MessageTransfer> messageTransfers = ((SourceSequenceTransfer)serializable).getMessageTransfers();
                messageTransfers.removeIf(messageTransfer -> messageNrs.contains(messageTransfer.getMessageNumber()));
            } else {
                List<MessageTransfer> messageTransfers = ((DestinationSequenceTransfer)serializable).getMessageTransfers();
                messageTransfers.removeIf(messageTransfer -> messageNrs.contains(messageTransfer.getMessageNumber()));
            }
            this.reliableMessagingStore.update(identifierValue, serializable);
        }
        catch (Exception e) {
            throw new RMStoreException((Throwable)e);
        }
    }

    private SourceSequence convertToSourceSequence(String identifierValue, SourceSequenceTransfer sourceSequenceTransfer) {
        Identifier identifier = new Identifier();
        identifier.setValue(identifierValue);
        Date expiry = 0L == sourceSequenceTransfer.getExpiry() ? null : new Date(sourceSequenceTransfer.getExpiry());
        String endpointIdentifierValue = sourceSequenceTransfer.getOfferingIdValue();
        Identifier endpointIdentifier = null;
        if (endpointIdentifierValue != null) {
            endpointIdentifier = org.apache.cxf.ws.rm.RMUtils.getWSRMFactory().createIdentifier();
            endpointIdentifier.setValue(endpointIdentifierValue);
        }
        long currentMessageNumber = sourceSequenceTransfer.getCurrentMessageNumber();
        boolean lastMessage = sourceSequenceTransfer.isLastMessage();
        ProtocolVariation protocolVariation = this.decodeProtocolVersion(sourceSequenceTransfer.getEndpointIdentifier());
        return new SourceSequence(identifier, expiry, endpointIdentifier, currentMessageNumber, lastMessage, protocolVariation);
    }

    private DestinationSequence convertToDestinationSequence(String identifierValue, DestinationSequenceTransfer destinationSequenceTransfer) {
        Identifier identifier = new Identifier();
        identifier.setValue(identifierValue);
        EndpointReferenceType acksTo = org.apache.cxf.ws.rm.RMUtils.createReference((String)destinationSequenceTransfer.getAddressValue());
        long lastMessageNumber = destinationSequenceTransfer.getLastMessageNumber();
        boolean isTerminate = destinationSequenceTransfer.isTerminate();
        SequenceAcknowledgement ack = null;
        byte[] bytes = destinationSequenceTransfer.getAcknowledged();
        if (null != bytes) {
            ack = RMUtils.toSequenceAcknowledgement(bytes);
        }
        ProtocolVariation protocolVariation = this.decodeProtocolVersion(destinationSequenceTransfer.getProtocolVersion());
        return new DestinationSequence(identifier, acksTo, lastMessageNumber, isTerminate, ack, protocolVariation);
    }

    private ProtocolVariation decodeProtocolVersion(String pv) {
        int d;
        if (null != pv && (d = pv.indexOf(32)) > 0) {
            return ProtocolVariation.findVariant((String)pv.substring(0, d), (String)pv.substring(d + 1));
        }
        return ProtocolVariation.RM10WSA200408;
    }
}

