/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.transport;

/**
 * This interface allows that different transports (such as JMS or HTTP) behave the same way when dispatching a Web Service
 * operation message.
 * <p>
 * The connection with the external server should be managed by the implementation of the dispatcher the client that accepts this
 * {@link TransportDispatcher}s will only call the dispatch method once the request has been built and will use the received
 * response to continue the processing.
 *
 * @since 1.0
 */
public interface TransportDispatcher {

  /**
   * Dispatches a soap message that is contained in a {@link TransportRequest} instance.
   *
   * @param request a {@link TransportRequest} instance.
   * @return a new {@link TransportResponse} instance.
   */
  TransportResponse dispatch(TransportRequest request) throws DispatcherException;
}
