/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.message.AddressingProperties;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapRequestBuilder;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.DispatcherException;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.internal.message.DefaultSoapRequest;
import org.mule.soap.internal.message.TestAddressingProperties;
import org.mule.soap.service.WSA11Service;
import org.mule.soap.service.WSA12Service;
import org.mule.soap.transport.TestHttpDispatcher;

public abstract class WsaExecutionTestCase
extends AbstractSoapServiceTestCase {
    private static final String MESSAGE_ID = "MESSAGE_ID_VALUE";
    private static final String TO = "TO_VALUE";
    private static final String FROM = "FROM_VALUE";
    private static final String RELATES_TO = "RELATES_TO_VALUE";
    private final String namespace;
    private final String filename;
    private TestWsaHttpDispatcher dispatcher;

    public WsaExecutionTestCase(String namespace, String filename) {
        this.namespace = namespace;
        this.filename = filename;
    }

    @Override
    protected String getServiceClass() {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? WSA11Service.class.getName() : WSA12Service.class.getName();
    }

    @Override
    public void doBefore() {
        this.dispatcher = new TestWsaHttpDispatcher(new TestHttpDispatcher());
    }

    @Test
    public void validateGeneratedRequest() throws Exception {
        DefaultSoapRequest request = SoapRequest.builder().addressingProperties((AddressingProperties)new TestAddressingProperties(this.namespace, "echoOperationCustomAction", TO, FROM, MESSAGE_ID, RELATES_TO)).content(this.testValues.getEchoResquest()).operation("echo").build();
        this.client.consume((SoapRequest)request, this.dispatcher);
        String requestContent = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResource(this.getFilename()).openStream(), (Charset)Charset.defaultCharset());
        SoapTestUtils.assertSimilarXml(requestContent, this.dispatcher.getRequestContent());
    }

    @Test
    public void simpleOperation() throws Exception {
        this.testSimpleOperation(this.client);
    }

    @Test
    public void echoWithLocalWsdl() throws Exception {
        URL wsdl = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        TestSoapClient localWsdlClient = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withWsdlLocation(wsdl.getPath()).withVersion(this.soapVersion).build());
        this.testSimpleOperation(localWsdlClient);
    }

    @Test
    public void simpleOperationWithHeaders() throws Exception {
        ImmutableMap headers = ImmutableMap.builder().put((Object)"headerIn", (Object)this.testValues.getHeaderIn()).put((Object)"headerInOut", (Object)this.testValues.getHeaderInOutRequest()).build();
        DefaultSoapRequest req = this.getSoapRequestBuilder("echoWithHeaders").content(this.testValues.getEchoWithHeadersRequest()).operation("echoWithHeaders").soapHeaders((Map)headers).contentType("application/xml").build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerOut"), this.testValues.getHeaderOut());
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerInOut"), this.testValues.getHeaderInOutResponse());
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoWithHeadersResponse(), response.getContent());
        this.assertAddressing(response);
    }

    @Test
    public void complexTypeOperation() throws Exception {
        DefaultSoapRequest req = this.getSoapRequestBuilder("echoAccount").content(this.testValues.getEchoAccountRequest()).operation("echoAccount").build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        this.assertAddressing(response);
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoAccountResponse(), response.getContent());
    }

    @Test
    public void noParamsOperation() throws Exception {
        DefaultSoapRequest req = this.getSoapRequestBuilder("noParams").content(this.testValues.getNoParamsRequest()).operation("noParams").build();
        this.testNoParams((SoapRequest)req);
    }

    @Test
    public void large() throws Exception {
        DefaultSoapRequest req = this.getSoapRequestBuilder("large").operation("large").build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        String largeContent = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResource("large.json").openStream(), (Charset)Charset.defaultCharset());
        this.assertAddressing(response);
        SoapTestUtils.assertSimilarXml(this.testValues.buildXml("largeResponse", "<largeResponse>" + largeContent + "</largeResponse>"), response.getContent());
    }

    @Test
    public void noParamsOperationWithoutXmlPayload() throws Exception {
        this.testNoParams((SoapRequest)this.getSoapRequestBuilder("noParams").operation("noParams").build());
    }

    @Test
    public void transportHeaders() throws Exception {
        DefaultSoapRequest request = this.getSoapRequestBuilder("echoOperationCustomAction").content(this.testValues.getEchoResquest()).operation("echo").build();
        SoapResponse response = this.client.consume((SoapRequest)request, null);
        Map transportHeaders = response.getTransportHeaders();
        MatcherAssert.assertThat(transportHeaders.entrySet(), (Matcher)Matchers.hasSize((int)4));
        this.assertAddressing(response);
    }

    @Test
    public void transportAdditionalData() throws Exception {
        DefaultSoapRequest request = this.getSoapRequestBuilder("echoOperationCustomAction").content(this.testValues.getEchoResquest()).operation("echo").build();
        SoapResponse response = this.client.consume((SoapRequest)request, null);
        Map transportHeaders = response.getTransportAdditionalData();
        MatcherAssert.assertThat(transportHeaders.entrySet(), (Matcher)Matchers.hasSize((int)3));
        this.assertAddressing(response);
    }

    @Test
    public void oneWayOperation() throws IOException {
        DefaultSoapRequest req = this.getSoapRequestBuilder("oneWay").operation("oneWay").content(this.testValues.getOneWayRequest()).build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getContent(), (Charset)Charset.defaultCharset()), (Matcher)Is.is((Object)""));
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)Is.is((Object)"*/*"));
    }

    private SoapRequestBuilder getSoapRequestBuilder(String action) {
        return SoapRequest.builder().addressingProperties((AddressingProperties)new TestAddressingProperties(this.namespace, action, this.server.getDefaultAddress(), null, MESSAGE_ID, null));
    }

    private String getFilename() {
        return "wsa/" + (this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? "SOAP11_" : "SOAP12_") + this.filename;
    }

    private void testSimpleOperation(SoapClient client) throws Exception {
        DefaultSoapRequest request = this.getSoapRequestBuilder("echoOperationCustomAction").content(this.testValues.getEchoResquest()).operation("echo").build();
        SoapResponse response = client.consume((SoapRequest)request, null);
        this.assertAddressing(response);
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoResponse(), response.getContent());
    }

    private void testNoParams(SoapRequest request) throws Exception {
        SoapResponse response = this.client.consume(request, null);
        this.assertAddressing(response);
        SoapTestUtils.assertSimilarXml(this.testValues.getNoParamsResponse(), response.getContent());
    }

    private void assertAddressing(SoapResponse response) throws Exception {
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)response.getSoapHeaders().size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(4)));
        MatcherAssert.assertThat((Object)response.getSoapHeaders().containsKey("Action"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)response.getSoapHeaders().containsKey("To"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)response.getSoapHeaders().containsKey("MessageID"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)response.getSoapHeaders().containsKey("RelatesTo"), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getAddressingHeader(this.namespace, "RelatesTo", MESSAGE_ID), (String)response.getSoapHeaders().get("RelatesTo"));
    }

    private static class TestWsaHttpDispatcher
    implements TransportDispatcher {
        private final TransportDispatcher dispatcher;
        private ByteArrayInputStream content;

        public TestWsaHttpDispatcher(TransportDispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public TransportResponse dispatch(TransportRequest request) throws DispatcherException {
            try {
                this.content = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)request.getContent()));
                return this.dispatcher.dispatch(new TransportRequest(this.getRequestContent(), request.getAddress(), request.getHeaders()));
            }
            catch (IOException e) {
                throw new DispatcherException("Error", (Throwable)e);
            }
        }

        public InputStream getRequestContent() {
            this.content.reset();
            return this.content;
        }
    }
}

