/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.exception;

/**
 * {@link Exception} implementation that aims to be thrown when a problem occur while encoding or decoding the content of a part
 * of a SOAP message.
 *
 * @since 1.0
 */
public final class EncodingException extends RuntimeException {

  public EncodingException(String message) {
    super(message);
  }

  public EncodingException(String message, Throwable cause) {
    super(message, cause);
  }
}
