/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.rm;

/**
 * Represents a request that aims to terminate a RM sequence
 *
 * @since 1.6
 */
public interface TerminateSequenceRequest {

  /**
   * @return the target sequence identifier.
   */
  String getSequenceIdentifier();

  /**
   * @return a {@link TerminateSequenceRequestBuilder} instance to create a new {@link TerminateSequenceRequest}.
   */
  static TerminateSequenceRequestBuilder builder() {
    return new TerminateSequenceRequestBuilder();
  }
}
