/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.security;

/**
 * Defines security action constants for the Mule SOAP engine. This class provides a clean abstraction over the underlying WSS4J
 * implementation and prevents direct exposure of Apache WSS4J constants in the public API.
 *
 * @since 1.0
 */
public final class SecurityActions {

  /**
   * Action for encrypting SOAP messages.
   */
  public static final String ENCRYPTION = "Encryption";

  /**
   * Action for signing SOAP messages.
   */
  public static final String SIGNATURE = "Signature";

  /**
   * Action for adding username tokens to SOAP messages.
   */
  public static final String USERNAME_TOKEN = "UsernameToken";

  /**
   * Action for adding timestamps to SOAP messages.
   */
  public static final String TIMESTAMP = "Timestamp";

  private SecurityActions() {
    // Utility class - prevent instantiation
  }
}
