/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.message.ReliableMessagingProperties;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.rm.TerminateSequenceRequest;
import org.mule.soap.api.transport.DispatcherException;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.message.TestReliableMessagingProperties;
import org.mule.soap.service.RM11Service;
import org.mule.soap.service.RM12Service;
import org.mule.soap.transport.TestHttpDispatcher;

public class RMExecutionTestCase
extends AbstractSoapServiceTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final String WSRM_200502 = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSRM_200702 = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    private static final String WSA_200408 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSA_200508 = "http://www.w3.org/2005/08/addressing";
    private static final String WSRM_10 = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSA_10 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSRM_10A = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSA_10A = "http://www.w3.org/2005/08/addressing";
    private static final String WSRM_11 = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    private static final String WSA_11 = "http://www.w3.org/2005/08/addressing";
    private TestRMHttpDispatcher rmDispatcher;

    @Override
    protected String getServiceClass() {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? RM11Service.class.getName() : RM12Service.class.getName();
    }

    @Override
    protected void doBefore() throws Exception {
        this.rmDispatcher = new TestRMHttpDispatcher(new TestHttpDispatcher());
    }

    @Test
    public void createSequenceVersion10Test() throws Exception {
        this.createSequenceVersionTest("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
    }

    @Test
    public void createSequenceVersion10ATest() throws Exception {
        this.createSequenceVersionTest("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://www.w3.org/2005/08/addressing");
    }

    @Test
    public void createSequenceVersion11Test() throws Exception {
        this.createSequenceVersionTest("http://docs.oasis-open.org/ws-rx/wsrm/200702", "http://www.w3.org/2005/08/addressing");
    }

    @Test
    public void createSequenceWithTtlTest() throws Exception {
        this.client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").sequenceTtl(5000L).build(), this.rmDispatcher);
        Assert.assertEquals((long)1L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(0).endsWith("CreateSequence"));
        SoapTestUtils.assertContainsXml(this.sequenceExpiresStringToAssert("P0Y0M0DT0H0M5.000S"), this.rmDispatcher.getRequestContent());
    }

    @Test
    public void createSequenceWithZeroTtlTest() throws Exception {
        this.client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").sequenceTtl(0L).build(), this.rmDispatcher);
        Assert.assertEquals((long)1L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(0).endsWith("CreateSequence"));
        SoapTestUtils.assertContainsXml(this.sequenceExpiresStringToAssert("PT0S"), this.rmDispatcher.getRequestContent());
    }

    @Test
    public void createSequenceWithNegativeTtlTest() throws Exception {
        this.client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").sequenceTtl(-1L).build(), this.rmDispatcher);
        Assert.assertEquals((long)1L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(0).endsWith("CreateSequence"));
        SoapTestUtils.assertContainsXml(this.sequenceExpiresStringToAssert("PT0S"), this.rmDispatcher.getRequestContent());
    }

    @Test
    public void createSequenceWithDefaultTtlTest() throws Exception {
        this.client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").build(), this.rmDispatcher);
        Assert.assertEquals((long)1L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(0).endsWith("CreateSequence"));
        SoapTestUtils.assertContainsXml(this.sequenceExpiresStringToAssert("PT0S"), this.rmDispatcher.getRequestContent());
    }

    @Test
    public void terminateSequenceTest() throws Exception {
        String sequenceId = this.client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").build(), this.rmDispatcher);
        this.client.terminateSequence(TerminateSequenceRequest.builder().sequenceIdentifier(sequenceId).build(), this.rmDispatcher);
        Assert.assertNotEquals((long)0L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(this.rmDispatcher.getCount() - 1).endsWith("TerminateSequence"));
        SoapTestUtils.assertContainsXml(this.terminateSequenceStringToAssert("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing", sequenceId), this.rmDispatcher.getRequestContent());
    }

    @Test
    public void executeOperationVersion10Test() throws Exception {
        this.executeOperationVersionTest("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
    }

    @Test
    public void executeOperationVersion10ATest() throws Exception {
        this.executeOperationVersionTest("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://www.w3.org/2005/08/addressing");
    }

    @Test
    public void executeOperationVersion11Test() throws Exception {
        this.executeOperationVersionTest("http://docs.oasis-open.org/ws-rx/wsrm/200702", "http://www.w3.org/2005/08/addressing");
    }

    private void createSequenceVersionTest(String namespace, String addressingNamespace) throws Exception {
        this.client.createSequence(CreateSequenceRequest.builder().namespaceUri(namespace).addressingNamespaceUri(addressingNamespace).build(), this.rmDispatcher);
        Assert.assertEquals((long)1L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(0).endsWith("CreateSequence"));
        SoapTestUtils.assertContainsXml(this.createSequenceStringToAssert(namespace, addressingNamespace), this.rmDispatcher.getRequestContent());
    }

    private void executeOperationVersionTest(String namespace, String addressingNamespace) throws Exception {
        String sid = this.client.createSequence(CreateSequenceRequest.builder().namespaceUri(namespace).addressingNamespaceUri(addressingNamespace).build(), this.rmDispatcher);
        this.client.consume((SoapRequest)SoapRequest.builder().operation("sayHi").content("<con:sayHi xmlns:con=\"http://service.connectors.mule.org/\"><arg0>Gabriel</arg0></con:sayHi>").reliableMessagingProperties((ReliableMessagingProperties)new TestReliableMessagingProperties(sid)).build(), this.rmDispatcher);
        this.client.terminateSequence(TerminateSequenceRequest.builder().sequenceIdentifier(sid).build(), this.rmDispatcher);
        Assert.assertEquals((long)3L, (long)this.rmDispatcher.getCount());
        SoapTestUtils.assertContainsXml(this.wsrmSequenceStringToAssert(namespace, addressingNamespace, sid, 1), this.rmDispatcher.getRequestContent(1));
    }

    private String createSequenceStringToAssert(String namespace, String addressingNamespace) {
        return "<wsrm:CreateSequence xmlns:wsrm=\"" + namespace + "\" xmlns:ns2=\"" + addressingNamespace + "\">";
    }

    private String sequenceExpiresStringToAssert(String sequenceTtl) {
        return "<wsrm:Expires>" + sequenceTtl + "</wsrm:Expires>";
    }

    private String sequenceIdentifierStringToAssert(String sequenceId) {
        return "<wsrm:Identifier>" + sequenceId + "</wsrm:Identifier>";
    }

    private String terminateSequenceStringToAssert(String namespace, String addressingNamespace, String sequenceId) {
        return "<wsrm:TerminateSequence xmlns:wsrm=\"" + namespace + "\" xmlns:ns2=\"" + addressingNamespace + "\">" + this.sequenceIdentifierStringToAssert(sequenceId) + "</wsrm:TerminateSequence>";
    }

    private String wsrmSequenceStringToAssert(String namespace, String addressingNamespace, String sequenceId, int messageNumber) {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? this.wsrmSequenceStringSoap11ToAssert(namespace, addressingNamespace, sequenceId, messageNumber) : this.wsrmSequenceStringSoap12ToAssert(namespace, addressingNamespace, sequenceId, messageNumber);
    }

    private String wsrmSequenceStringSoap11ToAssert(String namespace, String addressingNamespace, String sequenceId, int messageNumber) {
        return "<wsrm:Sequence soap:mustUnderstand=\"1\" xmlns:ns2=\"" + addressingNamespace + "\" xmlns:wsrm=\"" + namespace + "\"><wsrm:Identifier>" + sequenceId + "</wsrm:Identifier><wsrm:MessageNumber>" + messageNumber + "</wsrm:MessageNumber></wsrm:Sequence>";
    }

    private String wsrmSequenceStringSoap12ToAssert(String namespace, String addressingNamespace, String sequenceId, int messageNumber) {
        return "<wsrm:Sequence soap:mustUnderstand=\"true\" xmlns:ns2=\"" + addressingNamespace + "\" xmlns:wsrm=\"" + namespace + "\"><wsrm:Identifier>" + sequenceId + "</wsrm:Identifier><wsrm:MessageNumber>" + messageNumber + "</wsrm:MessageNumber></wsrm:Sequence>";
    }

    public static class TestRMHttpDispatcher
    implements TransportDispatcher {
        private final List<String> actions = new ArrayList<String>();
        private final List<ByteArrayInputStream> requestsContent = new ArrayList<ByteArrayInputStream>();
        private final TransportDispatcher dispatcher;
        private ByteArrayInputStream requestContent;
        private ByteArrayInputStream responseContent;
        private int count = 0;

        public TestRMHttpDispatcher(TransportDispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public TransportResponse dispatch(TransportRequest request) throws DispatcherException {
            try {
                ++this.count;
                this.actions.add(request.getHeader("SoapACTION").orElse(""));
                this.requestContent = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)request.getContent()));
                this.requestsContent.add(this.requestContent);
                TransportResponse response = this.dispatcher.dispatch(new TransportRequest(this.getRequestContent(), request.getAddress(), request.getHeaders()));
                this.responseContent = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)response.getContent()));
                return new TransportResponse((InputStream)this.responseContent, response.getHeaders(), response.getAdditionalData());
            }
            catch (IOException e) {
                throw new DispatcherException("Error", (Throwable)e);
            }
        }

        public InputStream getRequestContent() {
            this.requestContent.reset();
            return this.requestContent;
        }

        public InputStream getRequestContent(int index) {
            ByteArrayInputStream requestContent = this.requestsContent.get(index);
            requestContent.reset();
            return requestContent;
        }

        public InputStream getResponseContent() {
            this.responseContent.reset();
            return this.responseContent;
        }

        public int getCount() {
            return this.count;
        }

        public List<String> getActions() {
            return this.actions;
        }
    }
}

