/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm.store;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.persistence.RMStoreException;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.soap.api.exception.ReliableMessagingStoreException;
import org.mule.soap.api.rm.ReliableMessagingStore;
import org.mule.soap.internal.rm.store.RMStoreImp;

public class NegativeRmStoreImpTestCase {
    private ReliableMessagingStore<Serializable> brokenReliableMessagingStore = (ReliableMessagingStore)Mockito.mock(ReliableMessagingStore.class);
    private RMStore rmStore = new RMStoreImp(this.brokenReliableMessagingStore);

    @Before
    public void setup() throws Exception {
        ((ReliableMessagingStore)Mockito.doThrow(ReliableMessagingStoreException.class).when(this.brokenReliableMessagingStore)).store(ArgumentMatchers.anyString(), (Serializable)Mockito.any());
        ((ReliableMessagingStore)Mockito.doThrow(ReliableMessagingStoreException.class).when(this.brokenReliableMessagingStore)).remove(ArgumentMatchers.anyString());
        ((ReliableMessagingStore)Mockito.doThrow(ReliableMessagingStoreException.class).when(this.brokenReliableMessagingStore)).retrieveAll();
        ((ReliableMessagingStore)Mockito.doThrow(ReliableMessagingStoreException.class).when(this.brokenReliableMessagingStore)).retrieve(ArgumentMatchers.anyString());
    }

    @Test(expected=RMStoreException.class)
    public void errorCreateSourceSequence() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.createSourceSequence(sourceSequence);
    }

    @Test(expected=RMStoreException.class)
    public void errorCreateDestinationSequence() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        this.rmStore.createDestinationSequence(destinationSequence);
    }

    @Test(expected=RMStoreException.class)
    public void errorGetSourceSequence() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.getSourceSequence(sourceSequence.getIdentifier());
    }

    @Test(expected=RMStoreException.class)
    public void errorGetDestinationSequence() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        this.rmStore.getDestinationSequence(destinationSequence.getIdentifier());
    }

    @Test(expected=RMStoreException.class)
    public void errorRemoveSourceSequence() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.removeDestinationSequence(sourceSequence.getIdentifier());
    }

    @Test(expected=RMStoreException.class)
    public void errorRemoveDestinationSequence() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        this.rmStore.removeDestinationSequence(destinationSequence.getIdentifier());
    }

    @Test(expected=RMStoreException.class)
    public void errorGetSourceSequences() throws Exception {
        this.rmStore.getSourceSequences("anEndpointIdentifier");
    }

    @Test(expected=RMStoreException.class)
    public void errorGetDestinationSequences() throws Exception {
        this.rmStore.getDestinationSequences("anEndpointIdentifier");
    }

    @Test(expected=RMStoreException.class)
    public void errorGetMessages() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        this.rmStore.getMessages(sourceSequence.getIdentifier(), true);
    }

    @Test(expected=RMStoreException.class)
    public void errorPersistOutgoing() throws Exception {
        SourceSequence sourceSequence = this.createSourceSequence();
        RMMessage rmMessage = this.createRMMessage();
        this.rmStore.persistOutgoing(sourceSequence, rmMessage);
    }

    @Test(expected=RMStoreException.class)
    public void errorPersistIncoming() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        RMMessage rmMessage = this.createRMMessage();
        this.rmStore.persistIncoming(destinationSequence, rmMessage);
    }

    @Test(expected=RMStoreException.class)
    public void errorRemoveMessages() throws Exception {
        DestinationSequence destinationSequence = this.createDestinationSequence();
        RMMessage rmMessage = this.createRMMessage();
        ArrayList<Long> messageNumbers = new ArrayList<Long>();
        messageNumbers.add(rmMessage.getMessageNumber());
        this.rmStore.removeMessages(destinationSequence.getIdentifier(), messageNumbers, true);
    }

    private SourceSequence createSourceSequence() {
        Identifier identifier = new Identifier();
        identifier.setValue("seq");
        Date expires = new Date();
        Identifier offeringIdentifier = new Identifier();
        offeringIdentifier.setValue("offeringId");
        return new SourceSequence(identifier, expires, offeringIdentifier, 1L, false, ProtocolVariation.RM10WSA200408);
    }

    private DestinationSequence createDestinationSequence() {
        Identifier identifier = new Identifier();
        identifier.setValue("seq");
        EndpointReferenceType endpointReferenceType = RMUtils.createReference((String)"http://localhost:9999/");
        return new DestinationSequence(identifier, endpointReferenceType, null, ProtocolVariation.RM10WSA200408);
    }

    private RMMessage createRMMessage() throws Exception {
        RMMessage rmMessage = new RMMessage();
        InputStream fis = this.getClass().getResourceAsStream("SerializedRMMessage.txt");
        CachedOutputStream cos = new CachedOutputStream();
        IOUtils.copyAndCloseInput((InputStream)fis, (OutputStream)cos);
        cos.flush();
        rmMessage.setContent(cos);
        rmMessage.setContentType("text/xml");
        rmMessage.setTo("toAddress");
        rmMessage.setMessageNumber(1L);
        rmMessage.setCreatedTime(System.currentTimeMillis());
        return rmMessage;
    }
}

