/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.unit;

import jakarta.activation.DataHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.interceptor.OutputMtomSoapAttachmentsInterceptor;

public class OutputMtomSoapAttachmentsInterceptorTestCase {
    private static final String DATA_HANDLER_NAME = "dataHandlerName";
    private OutputMtomSoapAttachmentsInterceptor outputMtomSoapAttachmentsInterceptor = new OutputMtomSoapAttachmentsInterceptor();

    @Test
    public void handleMessageWithAttachmentWithoutContentType() throws IOException {
        Message message = this.getMessageMock();
        this.outputMtomSoapAttachmentsInterceptor.handleMessage(message);
        Exchange exchange = message.getExchange();
        Map map = (Map)exchange.get((Object)"mule.soap.attachments");
        Assert.assertThat((Object)((SoapAttachment)map.get(DATA_HANDLER_NAME)).getContentType(), (Matcher)Is.is((Object)"text/plain"));
    }

    private Message getMessageMock() throws IOException {
        DataHandler dataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)dataHandler.getName()).thenReturn((Object)DATA_HANDLER_NAME);
        Mockito.when((Object)dataHandler.getInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)dataHandler.getContentType()).thenReturn(null);
        Attachment attachment = (Attachment)Mockito.mock(Attachment.class);
        Mockito.when((Object)attachment.getDataHandler()).thenReturn((Object)dataHandler);
        List<Attachment> attachments = Collections.singletonList(attachment);
        ExchangeImpl exchange = new ExchangeImpl();
        Message messageMock = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)messageMock.getExchange()).thenReturn((Object)exchange);
        Mockito.when((Object)messageMock.getAttachments()).thenReturn(attachments);
        return messageMock;
    }
}

