/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import com.ctc.wstx.stax.WstxInputFactory;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.message.Exchange;
import org.jetbrains.annotations.Nullable;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.soap.api.exception.EncodingException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.util.CopyStream;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttachmentResponseEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentResponseEnricher.class);
    private static final AtomicBoolean alreadyLoggedWarning = new AtomicBoolean();
    private static final XMLInputFactory xmlInputFactory = new WstxInputFactory();
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private static final String ENVELOPE_BODY_TAG = "Body";
    private final Map<String, OperationModel> operations;

    AttachmentResponseEnricher(List<OperationModel> operations) {
        this.operations = operations.stream().collect(Collectors.toMap(OperationModel::getName, Function.identity(), (op1, op2) -> {
            if (alreadyLoggedWarning.compareAndSet(false, true)) {
                LOGGER.warn("Overloaded operations with different outputs are not fully supported");
            }
            return op1;
        }));
    }

    public InputStream enrich(XMLStreamReader xmlStreamReader, String operation, Exchange exchange) throws XMLStreamException {
        Collection attachmentsFields;
        MetadataType attachments = this.operations.get(operation).getOutputType().getAttachments();
        if (attachments instanceof ObjectType && !(attachmentsFields = ((ObjectType)attachments).getFields()).isEmpty()) {
            return this.processXmlStream(xmlStreamReader, attachmentsFields, exchange);
        }
        return this.processXmlStream(xmlStreamReader, Collections.emptySet(), exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream processXmlStream(XMLStreamReader xmlStreamReader, Collection<ObjectFieldType> attachmentsFields, Exchange exchange) throws XMLStreamException {
        List<String> attachmentNames = attachmentsFields.stream().map(MetadataTypeUtils::getLocalPart).collect(Collectors.toList());
        XmlEventEnricher eventEnricher = attachmentNames.isEmpty() ? new VoidXmlEventEnricher() : new XmlEventEnricher();
        XMLEventReader xmlEventReader = null;
        CopyStream outputByteStream = new CopyStream();
        try {
            xmlEventReader = xmlInputFactory.createXMLEventReader(xmlStreamReader);
            CustomXMLEventWriter xmlEventWriter = new CustomXMLEventWriter(outputByteStream);
            while (xmlEventReader.hasNext()) {
                XMLEvent enrichedEvent;
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (xmlEvent.isEndElement() && xmlEvent.asEndElement().getName().getLocalPart().equals(ENVELOPE_BODY_TAG)) {
                    if (xmlEvent.asEndElement().getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) break;
                    if (xmlEvent.asEndElement().getName().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                        break;
                    }
                }
                if ((enrichedEvent = eventEnricher.enrich(xmlEvent, attachmentNames, exchange)) == null) continue;
                xmlEventWriter.add(enrichedEvent, outputByteStream);
            }
        }
        finally {
            try {
                if (xmlEventReader != null) {
                    xmlEventReader.close();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.warn("Could not close XMLEventReader", (Throwable)e);
            }
        }
        return outputByteStream.toInputStream();
    }

    protected void processAttachmentData(String attachmentName, String attachmentData, Exchange exchange) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (exchange.get((Object)"mule.soap.attachments") != null) {
            builder.putAll((Map)exchange.get((Object)"mule.soap.attachments"));
        }
        builder.put((Object)attachmentName, (Object)this.buildAttachment(attachmentName, attachmentData));
        exchange.put((Object)"mule.soap.attachments", (Object)builder.build());
    }

    private SoapAttachment buildAttachment(String attachmentName, String attachmentData) {
        InputStream decodedAttachment = this.decodeAttachment(attachmentName, attachmentData);
        return new SoapAttachment(decodedAttachment, "*/*");
    }

    private InputStream decodeAttachment(String name, String attachmentContent) {
        try {
            return new ByteArrayInputStream(Base64.getDecoder().decode(attachmentContent));
        }
        catch (Exception e) {
            try {
                return new ByteArrayInputStream(Base64.getMimeDecoder().decode(attachmentContent));
            }
            catch (Exception ee) {
                throw new EncodingException(String.format("Cannot decode base64 attachment [%s]", name));
            }
        }
    }

    static {
        xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    private class VoidXmlEventEnricher
    extends XmlEventEnricher {
        private VoidXmlEventEnricher() {
        }

        @Override
        protected XMLEvent enrich(XMLEvent xmlEvent, List<String> attachmentNames, Exchange exchange) {
            return xmlEvent;
        }
    }

    private class XmlEventEnricher {
        private boolean processingAttachmentElement;
        private String attachmentName;
        private StringBuilder attachmentBuffer = new StringBuilder();

        private XmlEventEnricher() {
        }

        @Nullable
        protected XMLEvent enrich(XMLEvent xmlEvent, List<String> attachmentNames, Exchange exchange) {
            StartElement startElement;
            String localPart;
            if (this.processingAttachmentElement && xmlEvent.isEndElement()) {
                EndElement startElement2 = xmlEvent.asEndElement();
                String localPart2 = startElement2.getName().getLocalPart();
                if (localPart2.equals(this.attachmentName)) {
                    if (this.attachmentBuffer.length() != 0) {
                        AttachmentResponseEnricher.this.processAttachmentData(this.attachmentName, this.attachmentBuffer.toString(), exchange);
                        this.attachmentBuffer.setLength(0);
                    }
                    this.processingAttachmentElement = false;
                    this.attachmentName = null;
                }
                return null;
            }
            if (this.processingAttachmentElement) {
                if (xmlEvent.isCharacters()) {
                    this.attachmentBuffer.append(xmlEvent.asCharacters().getData());
                }
                return null;
            }
            if (xmlEvent.isStartElement() && attachmentNames.contains(localPart = (startElement = xmlEvent.asStartElement()).getName().getLocalPart())) {
                this.processingAttachmentElement = true;
                this.attachmentName = localPart;
                return null;
            }
            return xmlEvent;
        }
    }

    private class CustomXMLEventWriter {
        private XMLEventWriter writer;
        private int openedElements = 0;
        private boolean alreadyHasRoot = false;

        CustomXMLEventWriter(CopyStream outputByteStream) throws XMLStreamException {
            this.writer = xmlOutputFactory.createXMLEventWriter(outputByteStream);
        }

        public void add(XMLEvent enrichedEvent, CopyStream outputByteStream) throws XMLStreamException {
            if (!this.alreadyHasRoot) {
                if (enrichedEvent.isStartElement() || enrichedEvent.isStartDocument()) {
                    ++this.openedElements;
                } else if (enrichedEvent.isEndElement() || enrichedEvent.isEndDocument()) {
                    --this.openedElements;
                }
                this.writer.add(enrichedEvent);
                if (this.openedElements == 0 && (!enrichedEvent.isCharacters() || enrichedEvent.isCharacters() && !enrichedEvent.asCharacters().isWhiteSpace())) {
                    this.alreadyHasRoot = true;
                    this.close();
                }
                return;
            }
            this.writer = xmlOutputFactory.createXMLEventWriter(outputByteStream);
            this.alreadyHasRoot = false;
            this.add(enrichedEvent, outputByteStream);
        }

        public void close() {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                    this.writer.close();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.error("Could not close XMLEventWriter", (Throwable)e);
            }
        }
    }
}

