/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;

public class ProxyGZIPInInterceptor
extends GZIPInInterceptor {
    public void handleMessage(Message message) throws Fault {
        Map headers = (Map)message.getExchange().get((Object)"mule.soap.transport.headers");
        if (headers != null && Optional.ofNullable((String)headers.get("Content-Encoding")).map(h -> Arrays.asList(GZIPOutInterceptor.ENCODINGS.split(h.trim()))).filter(encs -> encs.contains("gzip") || encs.contains("x-gzip")).isPresent()) {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is == null) {
                return;
            }
            try {
                message.setContent(InputStream.class, (Object)new GZIPInputStream(is));
            }
            catch (IOException io) {
                throw new Fault((Throwable)io);
            }
        }
    }
}

