/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor.gzip;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;

public class ProxyGZIPOutInterceptor
extends GZIPOutInterceptor {
    public GZIPOutInterceptor.UseGzip gzipPermitted(Message message) {
        boolean useGzip = false;
        Map headers = (Map)message.getExchange().get((Object)"mule.soap.transport.headers");
        if (headers == null) {
            return GZIPOutInterceptor.UseGzip.NO;
        }
        Optional<String> header = Optional.ofNullable((String)headers.get("Content-Encoding"));
        if (header.isPresent()) {
            List<String> encodings = Arrays.asList(GZIPOutInterceptor.ENCODINGS.split(header.get().trim()));
            useGzip = encodings.contains("gzip") || encodings.contains("x-gzip");
        }
        return useGzip ? GZIPOutInterceptor.UseGzip.YES : GZIPOutInterceptor.UseGzip.NO;
    }
}

