/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.rm;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.soap.internal.rm.MuleRMManager;

public class MuleRMManagerTestCase {
    private static final String SEQUENCE_ID = "SEQUENCE_ID";
    private Bus bus;
    private Client client;
    private Endpoint endpoint;
    private RMManager manager;
    private Message message;
    private RMStore store;
    private RetransmissionQueue retransmissionQueue;
    private Source source;
    private RMEndpoint rmEndpoint;
    private Identifier identifier;

    @Before
    public void before() throws RMException {
        this.bus = (Bus)Mockito.mock(Bus.class);
        this.endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        this.manager = (RMManager)Mockito.mock(RMManager.class);
        this.message = (Message)Mockito.mock(Message.class);
        this.retransmissionQueue = (RetransmissionQueue)Mockito.mock(RetransmissionQueue.class);
        this.source = (Source)Mockito.mock(Source.class);
        this.store = (RMStore)Mockito.mock(RMStore.class);
        this.client = (Client)Mockito.mock(Client.class);
        this.rmEndpoint = (RMEndpoint)Mockito.mock(RMEndpoint.class);
        this.identifier = (Identifier)Mockito.mock(Identifier.class);
        Service service = (Service)Mockito.mock(Service.class);
        EndpointInfo endpointInfo = (EndpointInfo)Mockito.mock(EndpointInfo.class);
        ServiceInfo serviceInfo = (ServiceInfo)Mockito.mock(ServiceInfo.class);
        QName name = new QName("NAMESPACE", "LOCALPART", "PREFIX");
        Mockito.when((Object)this.manager.getSource(this.message)).thenReturn((Object)this.source);
        Mockito.when((Object)this.manager.getBus()).thenReturn((Object)this.bus);
        Mockito.when((Object)this.client.getEndpoint()).thenReturn((Object)this.endpoint);
        Mockito.when((Object)this.bus.getId()).thenReturn((Object)"BUS_ID");
        Mockito.when((Object)this.endpoint.getEndpointInfo()).thenReturn((Object)endpointInfo);
        Mockito.when((Object)this.endpoint.getService()).thenReturn((Object)service);
        Mockito.when((Object)endpointInfo.getService()).thenReturn((Object)serviceInfo);
        Mockito.when((Object)endpointInfo.getName()).thenReturn((Object)name);
        Mockito.when((Object)serviceInfo.getName()).thenReturn((Object)name);
        Mockito.when((Object)service.getName()).thenReturn((Object)name);
        Mockito.when((Object)this.manager.findReliableEndpoint(this.client.getEndpoint().getService().getName())).thenReturn((Object)this.rmEndpoint);
    }

    @Test
    public void useSequenceIdFromMessageTest() throws RMException {
        Mockito.when((Object)this.message.get((Object)"mule.reliablemessaging.sequence")).thenReturn((Object)SEQUENCE_ID);
        MuleRMManager sut = new MuleRMManager(this.manager);
        sut.getSequence(null, this.message, null);
        ((RMManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)0))).getSequence((Identifier)Mockito.any(), (Message)Mockito.any(), (AddressingProperties)Mockito.any());
        ((RMManager)Mockito.verify((Object)this.manager)).getSource(this.message);
        ((Source)Mockito.verify((Object)this.source)).getSequence((Identifier)Mockito.any());
    }

    @Test
    public void useDefaultImplTest() throws RMException {
        MuleRMManager sut = new MuleRMManager(this.manager);
        sut.getSequence(null, this.message, null);
        ((RMManager)Mockito.verify((Object)this.manager)).getSequence((Identifier)Mockito.any(), (Message)Mockito.any(), (AddressingProperties)Mockito.any());
        ((RMManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.times((int)0))).getSource(this.message);
    }

    @Test
    public void messageInjectedBeforeRecoverSequenceFromStoreTest() throws RMException {
        Mockito.when((Object)this.manager.getStore()).thenReturn((Object)this.store);
        Mockito.when((Object)this.manager.getRetransmissionQueue()).thenReturn((Object)this.retransmissionQueue);
        SourceSequence sourceSequence = (SourceSequence)Mockito.mock(SourceSequence.class);
        Mockito.when((Object)sourceSequence.getIdentifier()).thenReturn((Object)this.identifier);
        Mockito.when((Object)this.store.getSourceSequences((String)Mockito.any())).thenReturn(Arrays.asList(sourceSequence));
        Mockito.when((Object)this.rmEndpoint.getSource()).thenReturn((Object)this.source);
        Mockito.when((Object)this.source.getSequence(this.identifier)).thenReturn((Object)sourceSequence);
        MuleRMManager sut = new MuleRMManager(this.manager);
        sut.clientCreated(this.client);
        ((RMStore)Mockito.verify((Object)this.store)).persistOutgoing((SourceSequence)Mockito.any(), (RMMessage)Mockito.any());
        ((SourceSequence)Mockito.verify((Object)sourceSequence, (VerificationMode)Mockito.times((int)2))).setAcknowledged((SequenceAcknowledgement)Mockito.any());
    }

    @Test
    public void noMessageInjectedBeforeRecoverSequenceFromStoreTest() throws RMException {
        Mockito.when((Object)this.manager.getStore()).thenReturn((Object)this.store);
        Mockito.when((Object)this.manager.getRetransmissionQueue()).thenReturn((Object)this.retransmissionQueue);
        SourceSequence sourceSequence = (SourceSequence)Mockito.mock(SourceSequence.class);
        RMMessage message = (RMMessage)Mockito.mock(RMMessage.class);
        Mockito.when((Object)sourceSequence.getIdentifier()).thenReturn((Object)this.identifier);
        Mockito.when((Object)this.store.getSourceSequences((String)Mockito.any())).thenReturn(Arrays.asList(sourceSequence));
        Mockito.when((Object)this.store.getMessages(this.identifier, true)).thenReturn(Arrays.asList(message));
        MuleRMManager sut = new MuleRMManager(this.manager);
        sut.clientCreated(this.client);
        ((RMStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)0))).persistOutgoing((SourceSequence)Mockito.any(), (RMMessage)Mockito.any());
        ((SourceSequence)Mockito.verify((Object)sourceSequence, (VerificationMode)Mockito.times((int)0))).setAcknowledged((SequenceAcknowledgement)Mockito.any());
    }
}

